/*
 * Decompiled with CFR 0.152.
 */
package de.wenzlaff.kalender.logic;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.TextStyle;
import java.util.List;
import java.util.Locale;
import java.util.UUID;

public class Kalender {
    private Kalender() {
    }

    public static void generateICSFile(File file, LocalDate targetDate, LocalDate fromDate, String summaryText, List<String> selectedWorkdays) throws IOException {
        int totalDays;
        DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyyMMdd");
        Locale LOCALE_DE = Locale.forLanguageTag("DE");
        String PRODID = "-//TWSoft//TWRente Kalender Generator//EN";
        int daysRemaining = totalDays = (int)(targetDate.toEpochDay() - fromDate.toEpochDay()) + 1;
        try (FileWriter writer = new FileWriter(file);){
            writer.write("BEGIN:VCALENDAR\n");
            writer.write("VERSION:2.0\n");
            writer.write("PRODID:-//TWSoft//TWRente Kalender Generator//EN\n");
            LocalDate currentDate = fromDate;
            while (!currentDate.isAfter(targetDate)) {
                String currentWeekday = currentDate.getDayOfWeek().getDisplayName(TextStyle.FULL, LOCALE_DE);
                if (selectedWorkdays.contains(currentWeekday)) {
                    String formattedDate = currentDate.format(DATE_FORMATTER);
                    String uid = UUID.randomUUID().toString() + "@wenzlaff.info";
                    String eventSummary = summaryText.replace("#", String.valueOf(daysRemaining));
                    StringBuilder eventBuilder = new StringBuilder();
                    eventBuilder.append("BEGIN:VEVENT\n").append("UID:").append(formattedDate).append(uid).append("\n").append("DTSTAMP:").append(formattedDate).append("T000000Z\n").append("DTSTART;VALUE=DATE:").append(formattedDate).append("\n").append("DTEND;VALUE=DATE:").append(currentDate.plusDays(1L).format(DATE_FORMATTER)).append("\n").append("SUMMARY:").append(eventSummary).append("\n").append("END:VEVENT\n");
                    writer.write(eventBuilder.toString());
                }
                currentDate = currentDate.plusDays(1L);
                --daysRemaining;
            }
            writer.write("END:VCALENDAR\n");
        }
    }
}

