/*
 * Decompiled with CFR 0.152.
 */
package de.wenzlaff.twrente;

import de.wenzlaff.twrente.GenerateEventAction;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Taskbar;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URI;
import java.text.MessageFormat;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;

public class Gui {
    private static final String ZEITFORMAT = "dd.MM.yyyy";
    private static List<String> selectedDays = new ArrayList<String>();
    private static ResourceBundle bundle;
    private static Locale selectedLocale;

    public static void main(String[] args) {
        SwingUtilities.invokeLater(Gui::createAndShowGUI);
    }

    private static void createAndShowGUI() {
        Object[][] languages;
        ImageIcon icon = new ImageIcon(Gui.class.getResource("/icons/kleinhirn.png"));
        Image image = icon.getImage();
        bundle = ResourceBundle.getBundle("messages", selectedLocale);
        Locale.setDefault(selectedLocale);
        final JFrame frame = new JFrame(Gui.getFromBundle("window.title"));
        frame.setDefaultCloseOperation(3);
        frame.setSize(800, 400);
        frame.setLocationRelativeTo(null);
        frame.setIconImage(image);
        if (Taskbar.isTaskbarSupported()) {
            try {
                Taskbar.getTaskbar().setIconImage(image);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(12, 1));
        JLabel labelDateVon = new JLabel(Gui.getFromBundle("label.startDate"));
        labelDateVon.setBorder(new EmptyBorder(0, 10, 0, 0));
        panel.add(labelDateVon);
        LocalDate currentDate = LocalDate.now();
        String formattedDate = currentDate.format(DateTimeFormatter.ofPattern(ZEITFORMAT));
        JTextField dateFieldVon = new JTextField(formattedDate);
        panel.add(dateFieldVon);
        JLabel labelDate = new JLabel(Gui.getFromBundle("label.targetDate"));
        labelDate.setBorder(new EmptyBorder(0, 10, 0, 0));
        panel.add(labelDate);
        JTextField dateField = new JTextField(ZEITFORMAT);
        panel.add(dateField);
        JLabel labelSummary = new JLabel(Gui.getFromBundle("label.summary"));
        labelSummary.setBorder(new EmptyBorder(0, 10, 0, 0));
        panel.add(labelSummary);
        JTextField summaryField = new JTextField(Gui.getFromBundle("label.summary.default"));
        panel.add(summaryField);
        JLabel checkboxLabel = new JLabel(Gui.getFromBundle("label.weekdays"));
        checkboxLabel.setBorder(new EmptyBorder(0, 10, 0, 0));
        panel.add(checkboxLabel);
        JPanel checkboxWochentagePanel = new JPanel(new GridLayout(1, 7));
        List<String> weekdays = List.of("weekday.monday", "weekday.tuesday", "weekday.wednesday", "weekday.thursday", "weekday.friday", "weekday.saturday", "weekday.sunday");
        for (String key : weekdays) {
            String label = Gui.getFromBundle(key);
            Gui.addCheckbox(checkboxWochentagePanel, label);
        }
        panel.add(checkboxWochentagePanel);
        panel.add(new JPanel());
        JButton generateButton = new JButton(Gui.getFromBundle("button.generate"));
        generateButton.addActionListener(new GenerateEventAction(dateField, dateFieldVon, frame, summaryField, selectedDays, bundle));
        panel.add(generateButton);
        JPanel linkPanel = new JPanel(new FlowLayout(2));
        linkPanel.setBorder(new EmptyBorder(0, 0, 10, 10));
        JLabel linkLabel = new JLabel(Gui.getFromBundle("link.moreInfo"));
        linkLabel.setCursor(new Cursor(12));
        linkLabel.setToolTipText(Gui.getFromBundle("tooltip.link"));
        linkLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                try {
                    Desktop.getDesktop().browse(new URI("http://blog.wenzlaff.de/?s=twrente/"));
                }
                catch (Exception ex) {
                    String errorMsg = MessageFormat.format(Gui.getFromBundle("dialog.error.openBrowser"), ex.getMessage());
                    JOptionPane.showMessageDialog(frame, errorMsg);
                }
            }
        });
        linkPanel.add(linkLabel);
        frame.add((Component)panel, "Center");
        frame.add((Component)linkPanel, "South");
        JMenuBar menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu(Gui.getFromBundle("menu.file"));
        JMenuItem exitMenuItem = new JMenuItem(Gui.getFromBundle("menu.exit"));
        exitMenuItem.addActionListener(e -> System.exit(0));
        fileMenu.add(exitMenuItem);
        menuBar.add(fileMenu);
        JMenu settingsMenu = new JMenu(Gui.getFromBundle("menu.settings"));
        JMenu languageMenu = new JMenu(Gui.getFromBundle("menu.language"));
        for (Object[] lang : languages = new Object[][]{{"English", Locale.ENGLISH}, {"Deutsch", Locale.GERMAN}, {"Fran\u00e7ais", Locale.of("fr")}, {"\u65e5\u672c\u8a9e", Locale.of("jp")}, {"\u0420\u0443\u0441\u0441\u043a\u0438\u0439", Locale.of("ru")}, {"\u4e2d\u6587", Locale.of("cn")}, {"Espa\u00f1ol", Locale.of("es")}, {"Polski", Locale.of("pl")}, {"\u0939\u093f\u0928\u094d\u0926\u0940", Locale.of("hi")}, {"\u0627\u0644\u0639\u0631\u0628\u064a\u0629", Locale.of("ar")}, {"\u0395\u03bb\u03bb\u03b7\u03bd\u03b9\u03ba\u03ac", Locale.of("gr")}, {"\u05e2\u05d1\u05e8\u05d9\u05ea", Locale.of("il")}, {"\u09ac\u09be\u0982\u09b2\u09be", Locale.of("bn")}, {"Bahasa Indonesia", Locale.of("id")}, {"Basa Jawa", Locale.of("jv")}, {"\u0a2a\u0a70\u0a1c\u0a3e\u0a2c\u0a40", Locale.of("pa")}, {"Portugu\u00eas", Locale.of("pt")}, {"\u0627\u0631\u062f\u0648", Locale.of("ur")}}) {
            JMenuItem langItem = new JMenuItem((String)lang[0]);
            langItem.addActionListener(e -> Gui.switchLanguage((Locale)lang[1], frame));
            languageMenu.add(langItem);
        }
        settingsMenu.add(languageMenu);
        menuBar.add(settingsMenu);
        frame.setJMenuBar(menuBar);
        frame.add(panel);
        frame.setVisible(true);
    }

    private static String getFromBundle(String key) {
        Object value;
        try {
            value = bundle.getString(key);
        }
        catch (MissingResourceException e) {
            value = "Missing key: " + key;
        }
        return value;
    }

    private static void switchLanguage(Locale locale, JFrame frame) {
        selectedLocale = locale;
        bundle = ResourceBundle.getBundle("messages", selectedLocale);
        frame.dispose();
        Gui.createAndShowGUI();
    }

    private static void addCheckbox(JPanel checkboxPanel, String wochentag) {
        JCheckBox checkBox = new JCheckBox(wochentag);
        checkBox.setSelected(true);
        checkboxPanel.add(checkBox);
        selectedDays.add(wochentag);
        checkBox.addActionListener(e -> {
            if (checkBox.isSelected()) {
                selectedDays.add(wochentag);
            } else {
                selectedDays.remove(wochentag);
            }
        });
    }

    static {
        selectedLocale = Locale.GERMAN;
    }
}

