/*
 * Decompiled with CFR 0.152.
 */
package de.wenzlaff.kalender.logic;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.TextStyle;
import java.util.List;
import java.util.Locale;
import java.util.UUID;

public class Kalender {
    public static void generateICSFile(File fileName, LocalDate targetDate, LocalDate fromDate, String summaryText, List<String> selectedWorkday) throws IOException {
        int totalDays;
        FileWriter writer = new FileWriter(fileName);
        writer.write("BEGIN:VCALENDAR\n");
        writer.write("VERSION:2.0\n");
        writer.write("PRODID:-//TWSoft//TWRente Kalender Generator//EN\n");
        LocalDate currentDate = fromDate;
        int daysRemaining = totalDays = (int)(targetDate.toEpochDay() - fromDate.toEpochDay());
        while (!currentDate.isAfter(targetDate)) {
            DayOfWeek dayOfWeek = currentDate.getDayOfWeek();
            String currentWeekday = dayOfWeek.getDisplayName(TextStyle.FULL, Locale.forLanguageTag("DE"));
            if (selectedWorkday.contains(currentWeekday)) {
                String formattedDate = currentDate.format(DateTimeFormatter.ofPattern("yyyyMMdd"));
                String uuid = UUID.randomUUID().toString();
                String uid = uuid + "@wenzlaff.info";
                writer.write("BEGIN:VEVENT\n");
                writer.write("UID:" + formattedDate + uid + "\n");
                writer.write("DTSTAMP:" + formattedDate + "T000000Z\n");
                writer.write("DTSTART;VALUE=DATE:" + formattedDate + "\n");
                writer.write("DTEND;VALUE=DATE:" + formattedDate + "\n");
                writer.write("SUMMARY:" + summaryText.replace("#", String.valueOf(daysRemaining)) + "\n");
                writer.write("END:VEVENT\n");
            }
            currentDate = currentDate.plusDays(1L);
            --daysRemaining;
        }
        writer.write("END:VCALENDAR\n");
        writer.close();
    }
}

