/*
 * Decompiled with CFR 0.152.
 */
package de.wenzlaff.twrente;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.UUID;

public class Kalender {
    public static void generateICSFile(File fileName, LocalDate targetDate, LocalDate from, String summaryText) throws IOException {
        int totalDays;
        FileWriter writer = new FileWriter(fileName);
        writer.write("BEGIN:VCALENDAR\n");
        writer.write("VERSION:2.0\n");
        writer.write("PRODID:-//Java Calendar Generator//EN\n");
        LocalDate currentDate = from;
        int daysRemaining = totalDays = (int)(targetDate.toEpochDay() - from.toEpochDay());
        while (!currentDate.isAfter(targetDate)) {
            String formattedDate = currentDate.format(DateTimeFormatter.ofPattern("yyyyMMdd"));
            String uuid = UUID.randomUUID().toString();
            String uid = uuid + "@wenzlaff.info";
            writer.write("BEGIN:VEVENT\n");
            writer.write("UID:" + formattedDate + uid + "\n");
            writer.write("DTSTAMP:" + formattedDate + "T000000Z\n");
            writer.write("DTSTART;VALUE=DATE:" + formattedDate + "\n");
            writer.write("DTEND;VALUE=DATE:" + formattedDate + "\n");
            writer.write("SUMMARY:" + summaryText.replace("#", String.valueOf(daysRemaining)) + "\n");
            writer.write("END:VEVENT\n");
            currentDate = currentDate.plusDays(1L);
            --daysRemaining;
        }
        writer.write("END:VCALENDAR\n");
        writer.close();
    }
}

