/*
 * Decompiled with CFR 0.152.
 */
package de.wenzlaff.twrente;

import de.wenzlaff.twrente.Kalender;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileNameExtensionFilter;

public class Gui {
    private static final String ZEITFORMAT = "dd.MM.yyyy";

    public static void main(String[] args) {
        SwingUtilities.invokeLater(() -> {
            final JFrame frame = new JFrame("Kalender Event-Generator");
            frame.setDefaultCloseOperation(3);
            frame.setSize(800, 300);
            JPanel panel = new JPanel();
            panel.setLayout(new GridLayout(5, 1));
            JLabel labelDateVon = new JLabel("Ihr von Datum ein (dd.MM.yyyy):");
            panel.add(labelDateVon);
            LocalDate currentDate = LocalDate.now();
            String formattedDate = currentDate.format(DateTimeFormatter.ofPattern(ZEITFORMAT));
            final JTextField dateFieldVon = new JTextField(formattedDate);
            panel.add(dateFieldVon);
            JLabel labelDate = new JLabel("Ihr Ziel-Ereignisdatum ein (dd.MM.yyyy):");
            panel.add(labelDate);
            final JTextField dateField = new JTextField(ZEITFORMAT);
            panel.add(dateField);
            JLabel labelSummary = new JLabel("Text f\u00fcr die Zusammenfassung (f\u00fcr Z\u00e4hler ein #):");
            panel.add(labelSummary);
            final JTextField summaryField = new JTextField("# Tage bis zur Rente");
            panel.add(summaryField);
            JButton generateButton = new JButton("Kalender generieren");
            panel.add(generateButton);
            JButton exitButton = new JButton("Programm beenden");
            panel.add(exitButton);
            frame.add(panel);
            frame.setVisible(true);
            generateButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String inputDate = dateField.getText();
                    String summaryText = summaryField.getText();
                    try {
                        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(Gui.ZEITFORMAT);
                        LocalDate targetDate = LocalDate.parse(inputDate, formatter);
                        String vonDate = dateFieldVon.getText();
                        LocalDate fromDate = LocalDate.parse(vonDate, formatter);
                        if (!targetDate.isAfter(fromDate)) {
                            JOptionPane.showMessageDialog(frame, "Das Datum muss in der Zukunft liegen!", "Fehler", 0);
                            return;
                        }
                        JFileChooser fileChooser = this.getSaveDialog();
                        int userSelection = fileChooser.showSaveDialog(frame);
                        File selectedFile = null;
                        if (userSelection == 0) {
                            selectedFile = fileChooser.getSelectedFile();
                            System.out.println("Ausgew\u00e4hlte Datei: " + selectedFile.getAbsolutePath());
                        } else if (userSelection == 1) {
                            JOptionPane.showMessageDialog(frame, "Auswahl abgebrochen, nicht gespeichert!", "Info", 1);
                            return;
                        }
                        Kalender.generateICSFile(selectedFile, targetDate, fromDate, summaryText);
                        JOptionPane.showMessageDialog(frame, "Kalender erfolgreich generiert nach\n" + String.valueOf(selectedFile), "Erfolg", 1);
                    }
                    catch (Exception ex) {
                        JOptionPane.showMessageDialog(frame, "Ung\u00fcltiges Datum. Bitte verwenden Sie das Format dd.MM.yyyy", "Fehler", 0);
                    }
                }

                private JFileChooser getSaveDialog() {
                    JFileChooser fileChooser = new JFileChooser();
                    fileChooser.setDialogTitle("Kalender speichern unter ...");
                    FileNameExtensionFilter filter = new FileNameExtensionFilter("iCal Dateien (*.ics)", "ics");
                    fileChooser.setFileFilter(filter);
                    fileChooser.setCurrentDirectory(new File("."));
                    fileChooser.setSelectedFile(new File("calendar.ics"));
                    return fileChooser;
                }
            });
            exitButton.addActionListener(e -> System.exit(0));
        });
    }
}

