/*
 * Decompiled with CFR 0.152.
 */
package de.wenzlaff.twitmztransformer;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MapDataToMermaid {
    private static final String TAB = "  ";

    public static void main(String[] args) {
        if (args.length != 2) {
            System.out.println("Usage: java -cp twitmztransformer.jar de.wenzlaff.twitmztransformer.MapDataToMermaid <input.xml> <output.mm>");
            return;
        }
        String inputFilePath = args[0];
        String outputFilePath = args[1];
        MapDataToMermaid mermaid = new MapDataToMermaid();
        try {
            String map = mermaid.convertXmlToMermaid(inputFilePath);
            System.out.println(map);
            Files.writeString(Paths.get(outputFilePath, new String[0]), (CharSequence)map, new OpenOption[0]);
            System.out.println("Erzeuge Datei: " + outputFilePath);
        }
        catch (Exception e) {
            System.err.println(e.getLocalizedMessage());
        }
    }

    public String convertXmlToMermaid(String inputFilePath) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.parse(new File(inputFilePath));
        doc.getDocumentElement().normalize();
        NodeList topicList = doc.getElementsByTagName("topic");
        StringBuilder mermaidBuilder = new StringBuilder();
        mermaidBuilder.append("<pre class=\"mermaid\">\n---\nconfig:\n  look: handDrawn\n  theme: neutral\n---\nmindmap\n");
        this.prozess(topicList, mermaidBuilder);
        mermaidBuilder.append("</pre>\n<script src=\"https://cdn.jsdelivr.net/npm/mermaid/dist/mermaid.min.js\"></script>\n<script>mermaid.initialize({ startOnLoad: true });</script>");
        return mermaidBuilder.toString();
    }

    private void prozess(NodeList topicList, StringBuilder mermaidBuilder) {
        for (int i = 0; i < topicList.getLength(); ++i) {
            this.addNodes(topicList, mermaidBuilder, i);
        }
    }

    private void addNodes(NodeList topicList, StringBuilder mermaidBuilder, int i) {
        Node node = topicList.item(i);
        if (node.getNodeType() == 1) {
            Element topic = (Element)node;
            String text = MapDataToMermaid.removeLeadingAndTrailingStarsUndKlammern(topic.getAttribute("text"));
            if (i == 0) {
                mermaidBuilder.append("  root(" + text + ")\n");
            } else if (!text.isEmpty()) {
                mermaidBuilder.append("    " + text + "\n");
            }
        }
    }

    private static String removeLeadingAndTrailingStarsUndKlammern(String input) {
        if (input == null) {
            return "";
        }
        int index = input.indexOf("[1]: ");
        String result = index != -1 ? input.substring(0, index) : input;
        return result.replaceAll("^\\*+|\\*+$|\\(|\\)|\\[|\\]|\\|", "");
    }
}

