/*
 * Decompiled with CFR 0.152.
 */
package de.wenzlaff.twitmztransformer;

import java.io.File;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class MapDataToFreeMind {
    public static void main(String[] args) {
        if (args.length != 2) {
            System.out.println("Usage: java -jcp twitmztransformer.jar de.wenzlaff.twitmztransformer.MapDataToFreeMind <input.xml> <output.mm>");
            return;
        }
        String inputFilePath = args[0];
        String outputFilePath = args[1];
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document inputDoc = builder.parse(new File(inputFilePath));
            Document outputDoc = builder.newDocument();
            Element mapElement = outputDoc.createElement("map");
            mapElement.setAttribute("version", "0.9.0");
            outputDoc.appendChild(mapElement);
            Element topicsElement = (Element)inputDoc.getElementsByTagName("topics").item(0);
            if (topicsElement != null) {
                NodeList topics = topicsElement.getElementsByTagName("topic");
                for (int i = 0; i < topics.getLength(); ++i) {
                    Element topicElement = (Element)topics.item(i);
                    Element node = MapDataToFreeMind.convertTopicToNode(topicElement, outputDoc);
                    mapElement.appendChild(node);
                }
            }
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            DOMSource source = new DOMSource(outputDoc);
            StreamResult result = new StreamResult(new File(outputFilePath));
            transformer.transform(source, result);
            System.out.println("Conversion complete. Output saved to " + outputFilePath);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static Element convertTopicToNode(Element topicElement, Document doc) {
        Element node = doc.createElement("node");
        node.setAttribute("TEXT-SIZE", topicElement.getAttribute("text-size"));
        node.setAttribute("TEXT", MapDataToFreeMind.removeLeadingAndTrailingStars(topicElement.getAttribute("text")));
        String link = topicElement.getAttribute("link");
        if (!link.isEmpty()) {
            node.setAttribute("LINK", link);
        }
        NodeList childTopics = topicElement.getElementsByTagName("topic");
        for (int i = 0; i < childTopics.getLength(); ++i) {
            Element childTopic = (Element)childTopics.item(i);
            Element childNode = MapDataToFreeMind.convertTopicToNode(childTopic, doc);
            node.appendChild(childNode);
        }
        return node;
    }

    private static String removeLeadingAndTrailingStars(String input) {
        if (input == null) {
            return "";
        }
        return input.replaceAll("^\\*+|\\*+$", "");
    }
}

