/*
 * Decompiled with CFR 0.152.
 */
package de.wenzlaff.twitmztransformer;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class FileExtractor {
    public static void main(String[] args) {
        if (args.length != 2) {
            System.out.println("Usage: java -jar twitmztransformer.jar de.wenzlaff.twitmztransformer.FileExtractor <sourceDir> <destinationDir>");
            System.exit(1);
        }
        Path sourceDir = Paths.get(args[0], new String[0]);
        Path destinationDir = Paths.get(args[1], new String[0]);
        if (!Files.exists(sourceDir, new LinkOption[0]) || !Files.isDirectory(sourceDir, new LinkOption[0])) {
            System.err.println("Das Quellverzeichnis existiert nicht oder ist kein Verzeichnis: " + String.valueOf(sourceDir));
            System.exit(1);
        }
        try {
            Files.createDirectories(destinationDir, new FileAttribute[0]);
        }
        catch (IOException e) {
            System.err.println("Fehler beim Erstellen des Zielverzeichnisses: " + String.valueOf(destinationDir));
            e.printStackTrace();
            System.exit(1);
        }
        try {
            Files.walk(sourceDir, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(file -> {
                try {
                    if (file.toString().endsWith(".itmz")) {
                        FileExtractor.unzipFile(file, destinationDir);
                    }
                }
                catch (IOException e) {
                    System.err.println("Fehler beim Verarbeiten der Datei: " + String.valueOf(file));
                    e.printStackTrace();
                }
            });
        }
        catch (IOException e) {
            System.err.println("Fehler beim Durchlaufen des Quellverzeichnisses: " + String.valueOf(sourceDir));
            e.printStackTrace();
            System.exit(1);
        }
        System.out.println("Dateien wurden erfolgreich verarbeitet.");
    }

    private static void unzipFile(Path zipFilePath, Path destinationDir) throws IOException {
        System.out.println("verarbeite: unzip " + String.valueOf(zipFilePath) + " nach Ziel " + String.valueOf(destinationDir));
        String dateiname = FileExtractor.getFileNameWithoutExtension(zipFilePath);
        Path zielDir = destinationDir.resolve(dateiname);
        try (ZipInputStream zis = new ZipInputStream(Files.newInputStream(zipFilePath, new OpenOption[0]));){
            ZipEntry entry;
            while ((entry = zis.getNextEntry()) != null) {
                Path newFilePath = zielDir.resolve(entry.getName());
                if (entry.isDirectory()) {
                    Files.createDirectories(newFilePath, new FileAttribute[0]);
                } else {
                    Files.createDirectories(newFilePath.getParent(), new FileAttribute[0]);
                    try (OutputStream os = Files.newOutputStream(newFilePath, new OpenOption[0]);){
                        int length;
                        byte[] buffer = new byte[1024];
                        while ((length = zis.read(buffer)) > 0) {
                            os.write(buffer, 0, length);
                        }
                    }
                }
                zis.closeEntry();
            }
        }
    }

    private static String getFileNameWithoutExtension(Path path) {
        String fileName = path.getFileName().toString();
        int dotIndex = fileName.lastIndexOf(46);
        return dotIndex > 0 ? fileName.substring(0, dotIndex) : fileName;
    }

    private static void copyFile(Path file, Path sourceDir, Path destinationDir) throws IOException {
        Path relativePath = sourceDir.relativize(file);
        Path targetPath = destinationDir.resolve(relativePath);
        Files.createDirectories(targetPath.getParent(), new FileAttribute[0]);
        Files.copy(file, targetPath, StandardCopyOption.REPLACE_EXISTING);
    }
}

