<?xml version="1.0" encoding="UTF-8" standalone="no"?>
<map version="0.9.0">
  <node TEXT="Clean Code" TEXT-SIZE="117">
    <node TEXT="General rules" TEXT-SIZE="">
      <node TEXT="1    Follow standard conventions." TEXT-SIZE=""/>
      <node TEXT="2    Keep it simple stupid. Simpler is always better. Reduce complexity as much as possible." TEXT-SIZE=""/>
      <node TEXT="3    Boy scout rule. Leave the campground cleaner than you found it." TEXT-SIZE=""/>
      <node TEXT="4    Always find root cause. Always look for the root cause of a problem." TEXT-SIZE=""/>
    </node>
    <node TEXT="1    Follow standard conventions." TEXT-SIZE=""/>
    <node TEXT="2    Keep it simple stupid. Simpler is always better. Reduce complexity as much as possible." TEXT-SIZE=""/>
    <node TEXT="3    Boy scout rule. Leave the campground cleaner than you found it." TEXT-SIZE=""/>
    <node TEXT="4    Always find root cause. Always look for the root cause of a problem." TEXT-SIZE=""/>
    <node TEXT="Design rules" TEXT-SIZE="">
      <node TEXT="1    Keep configurable data at high levels." TEXT-SIZE="16"/>
      <node TEXT="2    Prefer polymorphism to if/else or switch/case." TEXT-SIZE="17"/>
      <node TEXT="3    Separate multi-threading code." TEXT-SIZE=""/>
      <node TEXT="4    Prevent over-configurability." TEXT-SIZE=""/>
      <node TEXT="5    Use dependency injection." TEXT-SIZE=""/>
      <node TEXT="6    Follow Law of Demeter. A class should know only its direct dependencies." TEXT-SIZE=""/>
    </node>
    <node TEXT="1    Keep configurable data at high levels." TEXT-SIZE="16"/>
    <node TEXT="2    Prefer polymorphism to if/else or switch/case." TEXT-SIZE="17"/>
    <node TEXT="3    Separate multi-threading code." TEXT-SIZE=""/>
    <node TEXT="4    Prevent over-configurability." TEXT-SIZE=""/>
    <node TEXT="5    Use dependency injection." TEXT-SIZE=""/>
    <node TEXT="6    Follow Law of Demeter. A class should know only its direct dependencies." TEXT-SIZE=""/>
    <node TEXT="Understandability tips" TEXT-SIZE="">
      <node TEXT="1    Be consistent. If you do something a certain way, do all similar things in the same way." TEXT-SIZE=""/>
      <node TEXT="2    Use explanatory variables." TEXT-SIZE=""/>
      <node TEXT="3    Encapsulate boundary conditions. Boundary conditions are hard to keep track of. Put the processing for them in one place." TEXT-SIZE=""/>
      <node TEXT="4    Prefer dedicated value objects to primitive type." TEXT-SIZE="16"/>
      <node TEXT="5    Avoid logical dependency. Don't write methods which works correctly depending on something else in the same class." TEXT-SIZE=""/>
      <node TEXT="6    Avoid negative conditionals." TEXT-SIZE=""/>
    </node>
    <node TEXT="1    Be consistent. If you do something a certain way, do all similar things in the same way." TEXT-SIZE=""/>
    <node TEXT="2    Use explanatory variables." TEXT-SIZE=""/>
    <node TEXT="3    Encapsulate boundary conditions. Boundary conditions are hard to keep track of. Put the processing for them in one place." TEXT-SIZE=""/>
    <node TEXT="4    Prefer dedicated value objects to primitive type." TEXT-SIZE="16"/>
    <node TEXT="5    Avoid logical dependency. Don't write methods which works correctly depending on something else in the same class." TEXT-SIZE=""/>
    <node TEXT="6    Avoid negative conditionals." TEXT-SIZE=""/>
    <node TEXT="Names rules" TEXT-SIZE="">
      <node TEXT="1    Choose descriptive and unambiguous names." TEXT-SIZE="15"/>
      <node TEXT="2    Make meaningful distinction." TEXT-SIZE=""/>
      <node TEXT="3    Use pronounceable names." TEXT-SIZE=""/>
      <node TEXT="4    Use searchable names." TEXT-SIZE=""/>
      <node TEXT="5    Replace magic numbers with named constants." TEXT-SIZE=""/>
      <node TEXT="6    Avoid encodings. Don't append prefixes or type information." TEXT-SIZE=""/>
    </node>
    <node TEXT="1    Choose descriptive and unambiguous names." TEXT-SIZE="15"/>
    <node TEXT="2    Make meaningful distinction." TEXT-SIZE=""/>
    <node TEXT="3    Use pronounceable names." TEXT-SIZE=""/>
    <node TEXT="4    Use searchable names." TEXT-SIZE=""/>
    <node TEXT="5    Replace magic numbers with named constants." TEXT-SIZE=""/>
    <node TEXT="6    Avoid encodings. Don't append prefixes or type information." TEXT-SIZE=""/>
    <node TEXT="" TEXT-SIZE=""/>
    <node TEXT="Functions rules" TEXT-SIZE="">
      <node TEXT="1    Small." TEXT-SIZE=""/>
      <node TEXT="2    Do one thing." TEXT-SIZE=""/>
      <node TEXT="3    Use descriptive names." TEXT-SIZE=""/>
      <node TEXT="4    Prefer fewer arguments." TEXT-SIZE=""/>
      <node TEXT="5    Have no side effects." TEXT-SIZE=""/>
      <node TEXT="6    Don't use flag arguments. Split method into several independent methods that can be called from the client without the flag." TEXT-SIZE=""/>
    </node>
    <node TEXT="1    Small." TEXT-SIZE=""/>
    <node TEXT="2    Do one thing." TEXT-SIZE=""/>
    <node TEXT="3    Use descriptive names." TEXT-SIZE=""/>
    <node TEXT="4    Prefer fewer arguments." TEXT-SIZE=""/>
    <node TEXT="5    Have no side effects." TEXT-SIZE=""/>
    <node TEXT="6    Don't use flag arguments. Split method into several independent methods that can be called from the client without the flag." TEXT-SIZE=""/>
    <node TEXT="Comments rules" TEXT-SIZE="">
      <node TEXT="1    Always try to explain yourself in code." TEXT-SIZE=""/>
      <node TEXT="2    Don't be redundant." TEXT-SIZE=""/>
      <node TEXT="3    Don't add obvious noise." TEXT-SIZE=""/>
      <node TEXT="4    Don't use closing brace comments." TEXT-SIZE=""/>
      <node TEXT="5    Don't comment out code. Just remove." TEXT-SIZE=""/>
      <node TEXT="6    Use as explanation of intent." TEXT-SIZE=""/>
      <node TEXT="7    Use as clarification of code." TEXT-SIZE=""/>
      <node TEXT="8    Use as warning of consequences." TEXT-SIZE=""/>
    </node>
    <node TEXT="1    Always try to explain yourself in code." TEXT-SIZE=""/>
    <node TEXT="2    Don't be redundant." TEXT-SIZE=""/>
    <node TEXT="3    Don't add obvious noise." TEXT-SIZE=""/>
    <node TEXT="4    Don't use closing brace comments." TEXT-SIZE=""/>
    <node TEXT="5    Don't comment out code. Just remove." TEXT-SIZE=""/>
    <node TEXT="6    Use as explanation of intent." TEXT-SIZE=""/>
    <node TEXT="7    Use as clarification of code." TEXT-SIZE=""/>
    <node TEXT="8    Use as warning of consequences." TEXT-SIZE=""/>
    <node TEXT="Source code structure" TEXT-SIZE="">
      <node TEXT="1    Separate concepts vertically." TEXT-SIZE=""/>
      <node TEXT="2    Related code should appear vertically dense." TEXT-SIZE=""/>
      <node TEXT="3    Declare variables close to their usage." TEXT-SIZE=""/>
      <node TEXT="4    Dependent functions should be close." TEXT-SIZE=""/>
      <node TEXT="5    Similar functions should be close." TEXT-SIZE=""/>
      <node TEXT="6    Place functions in the downward direction." TEXT-SIZE=""/>
      <node TEXT="7    Keep lines short." TEXT-SIZE=""/>
      <node TEXT="8    Don't use horizontal alignment." TEXT-SIZE=""/>
      <node TEXT="9    Use white space to associate related things and disassociate weakly related." TEXT-SIZE=""/>
      <node TEXT="10    Don't break indentation." TEXT-SIZE=""/>
    </node>
    <node TEXT="1    Separate concepts vertically." TEXT-SIZE=""/>
    <node TEXT="2    Related code should appear vertically dense." TEXT-SIZE=""/>
    <node TEXT="3    Declare variables close to their usage." TEXT-SIZE=""/>
    <node TEXT="4    Dependent functions should be close." TEXT-SIZE=""/>
    <node TEXT="5    Similar functions should be close." TEXT-SIZE=""/>
    <node TEXT="6    Place functions in the downward direction." TEXT-SIZE=""/>
    <node TEXT="7    Keep lines short." TEXT-SIZE=""/>
    <node TEXT="8    Don't use horizontal alignment." TEXT-SIZE=""/>
    <node TEXT="9    Use white space to associate related things and disassociate weakly related." TEXT-SIZE=""/>
    <node TEXT="10    Don't break indentation." TEXT-SIZE=""/>
    <node TEXT="Objects and data structures" TEXT-SIZE="">
      <node TEXT="1    Hide internal structure." TEXT-SIZE=""/>
      <node TEXT="2    Prefer data structures." TEXT-SIZE=""/>
      <node TEXT="3    Avoid hybrids structures (half object and half data)." TEXT-SIZE=""/>
      <node TEXT="4    Should be small." TEXT-SIZE=""/>
      <node TEXT="5    Do one thing." TEXT-SIZE=""/>
      <node TEXT="6    Small number of instance variables." TEXT-SIZE=""/>
      <node TEXT="7    Base class should know nothing about their derivatives." TEXT-SIZE=""/>
      <node TEXT="8    Better to have many functions than to pass some code into a function to select a behavior." TEXT-SIZE=""/>
      <node TEXT="9    Prefer non-static methods to static methods." TEXT-SIZE=""/>
    </node>
    <node TEXT="1    Hide internal structure." TEXT-SIZE=""/>
    <node TEXT="2    Prefer data structures." TEXT-SIZE=""/>
    <node TEXT="3    Avoid hybrids structures (half object and half data)." TEXT-SIZE=""/>
    <node TEXT="4    Should be small." TEXT-SIZE=""/>
    <node TEXT="5    Do one thing." TEXT-SIZE=""/>
    <node TEXT="6    Small number of instance variables." TEXT-SIZE=""/>
    <node TEXT="7    Base class should know nothing about their derivatives." TEXT-SIZE=""/>
    <node TEXT="8    Better to have many functions than to pass some code into a function to select a behavior." TEXT-SIZE=""/>
    <node TEXT="9    Prefer non-static methods to static methods." TEXT-SIZE=""/>
    <node TEXT="Tests" TEXT-SIZE="">
      <node TEXT="1    One assert per test." TEXT-SIZE=""/>
      <node TEXT="2    Readable." TEXT-SIZE=""/>
      <node TEXT="3    Fast." TEXT-SIZE=""/>
      <node TEXT="4    Independent." TEXT-SIZE=""/>
      <node TEXT="5    Repeatable." TEXT-SIZE=""/>
    </node>
    <node TEXT="1    One assert per test." TEXT-SIZE=""/>
    <node TEXT="2    Readable." TEXT-SIZE=""/>
    <node TEXT="3    Fast." TEXT-SIZE=""/>
    <node TEXT="4    Independent." TEXT-SIZE=""/>
    <node TEXT="5    Repeatable." TEXT-SIZE=""/>
    <node TEXT="Code smells" TEXT-SIZE="">
      <node TEXT="1    Rigidity. The software is difficult to change. A small change causes a cascade of subsequent changes." TEXT-SIZE=""/>
      <node TEXT="2    Fragility. The software breaks in many places due to a single change." TEXT-SIZE=""/>
      <node TEXT="3    Immobility. You cannot reuse parts of the code in other projects because of involved risks and high effort." TEXT-SIZE=""/>
      <node TEXT="4    Needless Complexity." TEXT-SIZE=""/>
      <node TEXT="5    Needless Repetition." TEXT-SIZE=""/>
      <node TEXT="6    Opacity. The code is hard to understand." TEXT-SIZE=""/>
    </node>
    <node TEXT="1    Rigidity. The software is difficult to change. A small change causes a cascade of subsequent changes." TEXT-SIZE=""/>
    <node TEXT="2    Fragility. The software breaks in many places due to a single change." TEXT-SIZE=""/>
    <node TEXT="3    Immobility. You cannot reuse parts of the code in other projects because of involved risks and high effort." TEXT-SIZE=""/>
    <node TEXT="4    Needless Complexity." TEXT-SIZE=""/>
    <node TEXT="5    Needless Repetition." TEXT-SIZE=""/>
    <node TEXT="6    Opacity. The code is hard to understand." TEXT-SIZE=""/>
    <node TEXT="Summary of 'Clean code' by Robert C. Martin" TEXT-SIZE="18"/>
    <node LINK="http://www.wenzlaff.de" TEXT="www.wenzlaff.de" TEXT-SIZE="14"/>
  </node>
  <node TEXT="General rules" TEXT-SIZE="">
    <node TEXT="1    Follow standard conventions." TEXT-SIZE=""/>
    <node TEXT="2    Keep it simple stupid. Simpler is always better. Reduce complexity as much as possible." TEXT-SIZE=""/>
    <node TEXT="3    Boy scout rule. Leave the campground cleaner than you found it." TEXT-SIZE=""/>
    <node TEXT="4    Always find root cause. Always look for the root cause of a problem." TEXT-SIZE=""/>
  </node>
  <node TEXT="1    Follow standard conventions." TEXT-SIZE=""/>
  <node TEXT="2    Keep it simple stupid. Simpler is always better. Reduce complexity as much as possible." TEXT-SIZE=""/>
  <node TEXT="3    Boy scout rule. Leave the campground cleaner than you found it." TEXT-SIZE=""/>
  <node TEXT="4    Always find root cause. Always look for the root cause of a problem." TEXT-SIZE=""/>
  <node TEXT="Design rules" TEXT-SIZE="">
    <node TEXT="1    Keep configurable data at high levels." TEXT-SIZE="16"/>
    <node TEXT="2    Prefer polymorphism to if/else or switch/case." TEXT-SIZE="17"/>
    <node TEXT="3    Separate multi-threading code." TEXT-SIZE=""/>
    <node TEXT="4    Prevent over-configurability." TEXT-SIZE=""/>
    <node TEXT="5    Use dependency injection." TEXT-SIZE=""/>
    <node TEXT="6    Follow Law of Demeter. A class should know only its direct dependencies." TEXT-SIZE=""/>
  </node>
  <node TEXT="1    Keep configurable data at high levels." TEXT-SIZE="16"/>
  <node TEXT="2    Prefer polymorphism to if/else or switch/case." TEXT-SIZE="17"/>
  <node TEXT="3    Separate multi-threading code." TEXT-SIZE=""/>
  <node TEXT="4    Prevent over-configurability." TEXT-SIZE=""/>
  <node TEXT="5    Use dependency injection." TEXT-SIZE=""/>
  <node TEXT="6    Follow Law of Demeter. A class should know only its direct dependencies." TEXT-SIZE=""/>
  <node TEXT="Understandability tips" TEXT-SIZE="">
    <node TEXT="1    Be consistent. If you do something a certain way, do all similar things in the same way." TEXT-SIZE=""/>
    <node TEXT="2    Use explanatory variables." TEXT-SIZE=""/>
    <node TEXT="3    Encapsulate boundary conditions. Boundary conditions are hard to keep track of. Put the processing for them in one place." TEXT-SIZE=""/>
    <node TEXT="4    Prefer dedicated value objects to primitive type." TEXT-SIZE="16"/>
    <node TEXT="5    Avoid logical dependency. Don't write methods which works correctly depending on something else in the same class." TEXT-SIZE=""/>
    <node TEXT="6    Avoid negative conditionals." TEXT-SIZE=""/>
  </node>
  <node TEXT="1    Be consistent. If you do something a certain way, do all similar things in the same way." TEXT-SIZE=""/>
  <node TEXT="2    Use explanatory variables." TEXT-SIZE=""/>
  <node TEXT="3    Encapsulate boundary conditions. Boundary conditions are hard to keep track of. Put the processing for them in one place." TEXT-SIZE=""/>
  <node TEXT="4    Prefer dedicated value objects to primitive type." TEXT-SIZE="16"/>
  <node TEXT="5    Avoid logical dependency. Don't write methods which works correctly depending on something else in the same class." TEXT-SIZE=""/>
  <node TEXT="6    Avoid negative conditionals." TEXT-SIZE=""/>
  <node TEXT="Names rules" TEXT-SIZE="">
    <node TEXT="1    Choose descriptive and unambiguous names." TEXT-SIZE="15"/>
    <node TEXT="2    Make meaningful distinction." TEXT-SIZE=""/>
    <node TEXT="3    Use pronounceable names." TEXT-SIZE=""/>
    <node TEXT="4    Use searchable names." TEXT-SIZE=""/>
    <node TEXT="5    Replace magic numbers with named constants." TEXT-SIZE=""/>
    <node TEXT="6    Avoid encodings. Don't append prefixes or type information." TEXT-SIZE=""/>
  </node>
  <node TEXT="1    Choose descriptive and unambiguous names." TEXT-SIZE="15"/>
  <node TEXT="2    Make meaningful distinction." TEXT-SIZE=""/>
  <node TEXT="3    Use pronounceable names." TEXT-SIZE=""/>
  <node TEXT="4    Use searchable names." TEXT-SIZE=""/>
  <node TEXT="5    Replace magic numbers with named constants." TEXT-SIZE=""/>
  <node TEXT="6    Avoid encodings. Don't append prefixes or type information." TEXT-SIZE=""/>
  <node TEXT="" TEXT-SIZE=""/>
  <node TEXT="Functions rules" TEXT-SIZE="">
    <node TEXT="1    Small." TEXT-SIZE=""/>
    <node TEXT="2    Do one thing." TEXT-SIZE=""/>
    <node TEXT="3    Use descriptive names." TEXT-SIZE=""/>
    <node TEXT="4    Prefer fewer arguments." TEXT-SIZE=""/>
    <node TEXT="5    Have no side effects." TEXT-SIZE=""/>
    <node TEXT="6    Don't use flag arguments. Split method into several independent methods that can be called from the client without the flag." TEXT-SIZE=""/>
  </node>
  <node TEXT="1    Small." TEXT-SIZE=""/>
  <node TEXT="2    Do one thing." TEXT-SIZE=""/>
  <node TEXT="3    Use descriptive names." TEXT-SIZE=""/>
  <node TEXT="4    Prefer fewer arguments." TEXT-SIZE=""/>
  <node TEXT="5    Have no side effects." TEXT-SIZE=""/>
  <node TEXT="6    Don't use flag arguments. Split method into several independent methods that can be called from the client without the flag." TEXT-SIZE=""/>
  <node TEXT="Comments rules" TEXT-SIZE="">
    <node TEXT="1    Always try to explain yourself in code." TEXT-SIZE=""/>
    <node TEXT="2    Don't be redundant." TEXT-SIZE=""/>
    <node TEXT="3    Don't add obvious noise." TEXT-SIZE=""/>
    <node TEXT="4    Don't use closing brace comments." TEXT-SIZE=""/>
    <node TEXT="5    Don't comment out code. Just remove." TEXT-SIZE=""/>
    <node TEXT="6    Use as explanation of intent." TEXT-SIZE=""/>
    <node TEXT="7    Use as clarification of code." TEXT-SIZE=""/>
    <node TEXT="8    Use as warning of consequences." TEXT-SIZE=""/>
  </node>
  <node TEXT="1    Always try to explain yourself in code." TEXT-SIZE=""/>
  <node TEXT="2    Don't be redundant." TEXT-SIZE=""/>
  <node TEXT="3    Don't add obvious noise." TEXT-SIZE=""/>
  <node TEXT="4    Don't use closing brace comments." TEXT-SIZE=""/>
  <node TEXT="5    Don't comment out code. Just remove." TEXT-SIZE=""/>
  <node TEXT="6    Use as explanation of intent." TEXT-SIZE=""/>
  <node TEXT="7    Use as clarification of code." TEXT-SIZE=""/>
  <node TEXT="8    Use as warning of consequences." TEXT-SIZE=""/>
  <node TEXT="Source code structure" TEXT-SIZE="">
    <node TEXT="1    Separate concepts vertically." TEXT-SIZE=""/>
    <node TEXT="2    Related code should appear vertically dense." TEXT-SIZE=""/>
    <node TEXT="3    Declare variables close to their usage." TEXT-SIZE=""/>
    <node TEXT="4    Dependent functions should be close." TEXT-SIZE=""/>
    <node TEXT="5    Similar functions should be close." TEXT-SIZE=""/>
    <node TEXT="6    Place functions in the downward direction." TEXT-SIZE=""/>
    <node TEXT="7    Keep lines short." TEXT-SIZE=""/>
    <node TEXT="8    Don't use horizontal alignment." TEXT-SIZE=""/>
    <node TEXT="9    Use white space to associate related things and disassociate weakly related." TEXT-SIZE=""/>
    <node TEXT="10    Don't break indentation." TEXT-SIZE=""/>
  </node>
  <node TEXT="1    Separate concepts vertically." TEXT-SIZE=""/>
  <node TEXT="2    Related code should appear vertically dense." TEXT-SIZE=""/>
  <node TEXT="3    Declare variables close to their usage." TEXT-SIZE=""/>
  <node TEXT="4    Dependent functions should be close." TEXT-SIZE=""/>
  <node TEXT="5    Similar functions should be close." TEXT-SIZE=""/>
  <node TEXT="6    Place functions in the downward direction." TEXT-SIZE=""/>
  <node TEXT="7    Keep lines short." TEXT-SIZE=""/>
  <node TEXT="8    Don't use horizontal alignment." TEXT-SIZE=""/>
  <node TEXT="9    Use white space to associate related things and disassociate weakly related." TEXT-SIZE=""/>
  <node TEXT="10    Don't break indentation." TEXT-SIZE=""/>
  <node TEXT="Objects and data structures" TEXT-SIZE="">
    <node TEXT="1    Hide internal structure." TEXT-SIZE=""/>
    <node TEXT="2    Prefer data structures." TEXT-SIZE=""/>
    <node TEXT="3    Avoid hybrids structures (half object and half data)." TEXT-SIZE=""/>
    <node TEXT="4    Should be small." TEXT-SIZE=""/>
    <node TEXT="5    Do one thing." TEXT-SIZE=""/>
    <node TEXT="6    Small number of instance variables." TEXT-SIZE=""/>
    <node TEXT="7    Base class should know nothing about their derivatives." TEXT-SIZE=""/>
    <node TEXT="8    Better to have many functions than to pass some code into a function to select a behavior." TEXT-SIZE=""/>
    <node TEXT="9    Prefer non-static methods to static methods." TEXT-SIZE=""/>
  </node>
  <node TEXT="1    Hide internal structure." TEXT-SIZE=""/>
  <node TEXT="2    Prefer data structures." TEXT-SIZE=""/>
  <node TEXT="3    Avoid hybrids structures (half object and half data)." TEXT-SIZE=""/>
  <node TEXT="4    Should be small." TEXT-SIZE=""/>
  <node TEXT="5    Do one thing." TEXT-SIZE=""/>
  <node TEXT="6    Small number of instance variables." TEXT-SIZE=""/>
  <node TEXT="7    Base class should know nothing about their derivatives." TEXT-SIZE=""/>
  <node TEXT="8    Better to have many functions than to pass some code into a function to select a behavior." TEXT-SIZE=""/>
  <node TEXT="9    Prefer non-static methods to static methods." TEXT-SIZE=""/>
  <node TEXT="Tests" TEXT-SIZE="">
    <node TEXT="1    One assert per test." TEXT-SIZE=""/>
    <node TEXT="2    Readable." TEXT-SIZE=""/>
    <node TEXT="3    Fast." TEXT-SIZE=""/>
    <node TEXT="4    Independent." TEXT-SIZE=""/>
    <node TEXT="5    Repeatable." TEXT-SIZE=""/>
  </node>
  <node TEXT="1    One assert per test." TEXT-SIZE=""/>
  <node TEXT="2    Readable." TEXT-SIZE=""/>
  <node TEXT="3    Fast." TEXT-SIZE=""/>
  <node TEXT="4    Independent." TEXT-SIZE=""/>
  <node TEXT="5    Repeatable." TEXT-SIZE=""/>
  <node TEXT="Code smells" TEXT-SIZE="">
    <node TEXT="1    Rigidity. The software is difficult to change. A small change causes a cascade of subsequent changes." TEXT-SIZE=""/>
    <node TEXT="2    Fragility. The software breaks in many places due to a single change." TEXT-SIZE=""/>
    <node TEXT="3    Immobility. You cannot reuse parts of the code in other projects because of involved risks and high effort." TEXT-SIZE=""/>
    <node TEXT="4    Needless Complexity." TEXT-SIZE=""/>
    <node TEXT="5    Needless Repetition." TEXT-SIZE=""/>
    <node TEXT="6    Opacity. The code is hard to understand." TEXT-SIZE=""/>
  </node>
  <node TEXT="1    Rigidity. The software is difficult to change. A small change causes a cascade of subsequent changes." TEXT-SIZE=""/>
  <node TEXT="2    Fragility. The software breaks in many places due to a single change." TEXT-SIZE=""/>
  <node TEXT="3    Immobility. You cannot reuse parts of the code in other projects because of involved risks and high effort." TEXT-SIZE=""/>
  <node TEXT="4    Needless Complexity." TEXT-SIZE=""/>
  <node TEXT="5    Needless Repetition." TEXT-SIZE=""/>
  <node TEXT="6    Opacity. The code is hard to understand." TEXT-SIZE=""/>
  <node TEXT="Summary of 'Clean code' by Robert C. Martin" TEXT-SIZE="18"/>
  <node LINK="http://www.wenzlaff.de" TEXT="www.wenzlaff.de" TEXT-SIZE="14"/>
</map>
