/*
 * Decompiled with CFR 0.152.
 */
package de.wenzlaff.twflug.be;

import de.wenzlaff.twflug.be.FieldDataRaw;
import de.wenzlaff.twflug.be.Parameter;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FlugInfosProTag {
    private static final Logger LOG = LogManager.getLogger((String)FlugInfosProTag.class.getName());
    private List<String> flugInfosProTag = new ArrayList<String>();
    private Parameter parameter;

    public void setParameter(Parameter parameter) {
        this.parameter = parameter;
    }

    public void addNachricht(FieldDataRaw nachricht) {
        if (nachricht != null) {
            if (this.isNachrichtValid(nachricht)) {
                String key = nachricht.getHexIdent();
                if (!this.flugInfosProTag.contains(key)) {
                    this.flugInfosProTag.add(key);
                }
            } else if (this.parameter != null && this.parameter.isDebug()) {
                LOG.info("INFO: Es gibt kein Key (HexIdent) in der Nachricht. Flugzeug bzw. Nachricht kann nicht identifiziert werden und wird ignoriert. Die Fehlerhafte Nachricht: " + nachricht);
            }
        } else if (this.parameter != null && this.parameter.isDebug()) {
            LOG.info("INFO: Es muss eine Nachricht zum hinzuf\u00fcgen \u00fcbergeben werden. Nachricht = null");
        }
    }

    private boolean isNachrichtValid(FieldDataRaw nachricht) {
        return nachricht.getHexIdent() != null && !nachricht.getHexIdent().isEmpty();
    }

    public void setMaxAnzahlFlugzeugeAufNull() {
        this.flugInfosProTag.clear();
    }

    public int getAnzahlFlugzeugeProTag() {
        return this.flugInfosProTag.size();
    }
}

