/*
 * Decompiled with CFR 0.152.
 */
package de.wenzlaff.twflug.be;

import de.wenzlaff.twflug.be.FieldDataRaw;
import de.wenzlaff.twflug.be.Parameter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FlugInfos {
    private static final Logger LOG = LogManager.getLogger((String)FlugInfos.class.getName());
    private Map<String, List<FieldDataRaw>> flugInfos = new HashMap<String, List<FieldDataRaw>>();
    private Parameter parameter;

    public void addNachricht(FieldDataRaw nachricht) {
        if (nachricht != null) {
            if (this.isNachrichtValid(nachricht)) {
                String key = nachricht.getHexIdent();
                if (this.flugInfos.containsKey(key)) {
                    List<FieldDataRaw> satz = this.flugInfos.get(key);
                    satz.add(nachricht);
                } else {
                    ArrayList<FieldDataRaw> satz = new ArrayList<FieldDataRaw>();
                    satz.add(nachricht);
                    this.flugInfos.put(key, satz);
                }
            } else if (this.parameter != null && this.parameter.isDebug()) {
                LOG.info("INFO: Es gibt kein Key (HexIdent) in der Nachricht. Flugzeug bzw. Nachricht kann nicht identifiziert werden und wird ignoriert. Die Fehlerhafte Nachricht: " + nachricht);
            }
        } else if (this.parameter != null && this.parameter.isDebug()) {
            LOG.info("INFO: Es muss eine Nachricht zum hinzuf\u00fcgen \u00fcbergeben werden. Nachricht = null");
        }
    }

    private boolean isNachrichtValid(FieldDataRaw nachricht) {
        return nachricht.getHexIdent() != null && !nachricht.getHexIdent().isEmpty();
    }

    public int getMaxAnzahlFlugzeuge() {
        return this.flugInfos.size();
    }

    public List<FieldDataRaw> getAlleNachrichtenZumFlugzeug(String key) {
        return this.flugInfos.get(key);
    }

    public void setMaxAnzahlFlugzeugeAufNull() {
        this.flugInfos.clear();
    }

    public void setParameter(Parameter parameter) {
        this.parameter = parameter;
    }
}

