/*
 * Decompiled with CFR 0.152.
 */
package de.wenzlaff.twflug;

import de.wenzlaff.twflug.be.FieldDataRaw;
import de.wenzlaff.twflug.be.FlugInfos;
import de.wenzlaff.twflug.be.FlugInfosProTag;
import de.wenzlaff.twflug.be.Parameter;
import java.io.File;
import java.io.IOException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Util {
    private static final String ENTFERNTER_PFAD = "/home/pi/fhem/log/";
    private static final Logger LOG = LogManager.getLogger((String)Util.class.getName());
    private static final DateTimeFormatter ZEITSTEMPEL_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd_HH:mm:ss");
    private static final DateTimeFormatter ZEITSTEMPEL_FORMAT_JAHR = DateTimeFormatter.ofPattern("yyyy-MM");
    private static final String DATEINAME_FLUGDATEN = "flugdaten-";
    private static final String DATEINAME_EXTENSION_FLUGDATEN = ".log";

    public static FieldDataRaw getFieldData(String empfangeneNachricht) {
        if (empfangeneNachricht == null) {
            throw new IllegalArgumentException("Die empfangeneNachricht ist null");
        }
        if (empfangeneNachricht.isEmpty()) {
            throw new IllegalArgumentException("Die empfangeneNachricht ist leer");
        }
        String[] nachricht = empfangeneNachricht.split(",");
        FieldDataRaw d = new FieldDataRaw();
        d.setMessageType(nachricht[0]);
        d.setTransmissionType(nachricht[1]);
        d.setSessionId(nachricht[2]);
        d.setAircraftId(nachricht[3]);
        d.setHexIdent(nachricht[4]);
        d.setFlightId(nachricht[5]);
        d.setDateMessageGenerated(nachricht[6]);
        d.setTimeMessageGenerated(nachricht[7]);
        d.setDateMessageLogged(nachricht[8]);
        d.setTimeMessageLogged(nachricht[9]);
        d.setCallsign(nachricht[10]);
        d.setAltitude(nachricht[11]);
        d.setGroundSpeed(nachricht[12]);
        d.setTrack(nachricht[13]);
        d.setLatitude(nachricht[14]);
        d.setLongitude(nachricht[15]);
        d.setVerticalRate(nachricht[16]);
        d.setSquawk(nachricht[17]);
        d.setAlertSquawkChange(nachricht[18]);
        d.setEmergency(nachricht[19]);
        d.setSpiIdent(nachricht[20]);
        d.setIsOnGround(nachricht[21]);
        return d;
    }

    public static File getLokaleOutputDatei() {
        LocalDate heute = LocalDate.now();
        String jahrMonat = ZEITSTEMPEL_FORMAT_JAHR.format(heute);
        String dateiName = DATEINAME_FLUGDATEN + jahrMonat + DATEINAME_EXTENSION_FLUGDATEN;
        File dateiname = new File(dateiName);
        return dateiname;
    }

    public static File getEntfernteOutputDatei() {
        String zielDatei = ENTFERNTER_PFAD + Util.getLokaleOutputDatei();
        File entfernteOutputDatei = new File(zielDatei);
        return entfernteOutputDatei;
    }

    private static String getZeitstempel() {
        LocalDateTime heute = LocalDateTime.now();
        String zeitstempel = ZEITSTEMPEL_FORMAT.format(heute);
        return zeitstempel;
    }

    public static void writeFlugdaten(FlugInfos flugzeuge, Parameter parameter) {
        if (flugzeuge == null || parameter == null) {
            throw new IllegalArgumentException("Die FlugInfos oder/und die Parameter sind null");
        }
        File lokaleOutputDatei = Util.getLokaleOutputDatei();
        String zeitstempel = Util.getZeitstempel();
        String zeile = zeitstempel + " flugdaten anzahl: " + flugzeuge.getMaxAnzahlFlugzeuge() + System.getProperty("line.separator");
        try {
            FileUtils.writeStringToFile((File)lokaleOutputDatei, (String)zeile, (boolean)true);
            if (parameter.isDebug() && LOG.isInfoEnabled()) {
                LOG.info("Daten in " + lokaleOutputDatei + " Datei geschrieben: " + zeile);
            }
        }
        catch (IOException e) {
            LOG.error("Fehler beim schreiben der Flugdaten.", (Throwable)e);
        }
    }

    public static void writeFlugdatenProTag(FlugInfosProTag flugzeuge, Parameter parameter) {
        if (flugzeuge == null || parameter == null) {
            throw new IllegalArgumentException("Die FlugInfosProTag oder/und die Parameter sind null");
        }
        File lokaleOutputDatei = Util.getLokaleOutputDatei();
        String zeitstempel = Util.getZeitstempel();
        String zeile = zeitstempel + " flugdaten summe-pro-tag: " + flugzeuge.getAnzahlFlugzeugeProTag() + System.getProperty("line.separator");
        try {
            FileUtils.writeStringToFile((File)lokaleOutputDatei, (String)zeile, (boolean)true);
            if (parameter.isDebug() && LOG.isInfoEnabled()) {
                LOG.info("Daten in " + lokaleOutputDatei + " Datei geschrieben: " + zeile);
            }
        }
        catch (IOException e) {
            LOG.error("Fehler beim schreiben der Flugdaten.", (Throwable)e);
        }
    }
}

