/*
 * Decompiled with CFR 0.152.
 */
package de.wenzlaff.twflug;

import de.wenzlaff.twflug.Util;
import de.wenzlaff.twflug.action.AnzahlProTagAction;
import de.wenzlaff.twflug.action.CopyAction;
import de.wenzlaff.twflug.action.EmergencyAction;
import de.wenzlaff.twflug.action.ThingSpeakAction;
import de.wenzlaff.twflug.action.WriteAction;
import de.wenzlaff.twflug.be.FieldDataRaw;
import de.wenzlaff.twflug.be.FlugInfos;
import de.wenzlaff.twflug.be.FlugInfosProTag;
import de.wenzlaff.twflug.be.Parameter;
import de.wenzlaff.twflug.gui.HauptFenster;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.Socket;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Client {
    private static final Logger LOG = LogManager.getLogger((String)Client.class.getName());
    private static final int DELAY = 60000;
    private FlugInfos flugzeuge;
    private FlugInfosProTag flugInfosProTag;
    private Parameter parameter;
    private HauptFenster hauptFenster;
    private ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);

    public Client() {
        this.flugzeuge = new FlugInfos();
        this.flugInfosProTag = new FlugInfosProTag();
    }

    public void start(Parameter parameter) throws IOException {
        this.parameter = parameter;
        this.flugzeuge.setParameter(parameter);
        this.flugInfosProTag.setParameter(parameter);
        if (!parameter.isNoGui()) {
            this.hauptFenster = new HauptFenster(parameter);
        }
        Socket socket = new Socket(parameter.getIp(), parameter.getPort());
        this.resetFlugInfoTimer(parameter.getRefreshTime());
        this.startCopyTimer();
        this.startAnzahlProTagTimer();
        this.startThingSpeakTimer();
        while (true) {
            try {
                while (true) {
                    String empfangeneNachricht;
                    if (!this.isNachrichtValid(empfangeneNachricht = this.leseNachricht(socket))) {
                        continue;
                    }
                    FieldDataRaw fd = Util.getFieldData(empfangeneNachricht);
                    if (parameter.isDebug()) {
                        System.out.println(fd);
                    }
                    this.flugzeuge.addNachricht(fd);
                    this.flugInfosProTag.addNachricht(fd);
                    if (fd.isEmergency() == FieldDataRaw.EMERGENCY.YES) {
                        new EmergencyAction(fd, parameter);
                    }
                    if (parameter.isNoGui()) continue;
                    this.hauptFenster.aktualisieren(this.flugzeuge.getMaxAnzahlFlugzeuge());
                }
            }
            catch (Exception exception) {
                continue;
            }
            break;
        }
    }

    private boolean isNachrichtValid(String empfangeneNachricht) {
        return empfangeneNachricht.codePointCount(0, empfangeneNachricht.length()) > 9;
    }

    private String leseNachricht(Socket socket) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
        char[] buffer = new char[200];
        int anzahlZeichen = bufferedReader.read(buffer, 0, 200);
        String nachricht = new String(buffer, 0, anzahlZeichen);
        return nachricht;
    }

    private void resetFlugInfoTimer(int ms) {
        Timer timer = new Timer("WriteAction");
        timer.schedule((TimerTask)new WriteAction(this.flugzeuge, this.parameter), 60000L, (long)ms);
    }

    private void startCopyTimer() {
        Timer timer = new Timer("CopyAction");
        timer.schedule((TimerTask)new CopyAction(this.parameter), 30000L, (long)this.parameter.getCopyTime());
    }

    private void startAnzahlProTagTimer() {
        Long mitternacht = LocalDateTime.now().until(LocalDate.now().plusDays(1L).atStartOfDay(), ChronoUnit.MINUTES);
        this.scheduler.scheduleAtFixedRate(new AnzahlProTagAction(this.flugInfosProTag, this.parameter), mitternacht, 1440L, TimeUnit.MINUTES);
    }

    private void startThingSpeakTimer() {
        Timer timer = new Timer("ThingSpeakServiceAction");
        timer.schedule((TimerTask)new ThingSpeakAction(this.flugzeuge, this.parameter), 30000L, this.parameter.getSendToThingSpeakTime());
    }
}

