package de.wenzlaff.twflug.be;

/*
 * #%L
 * twflug
 * %%
 * Copyright (C) 2015 Thomas Wenzlaff
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * #L%
 */

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

/**
 * Die Möglichen 6 Message Typen.
 * 
 * Message types
 * 
 * There are six message types - MSG, SEL, ID, AIR, STA, CLK. Most data from aircraft is contained in the MSG lines whilst the other types are triggered by user
 * input or system settings.
 * 
 * The MSG data was inhibited with a five minute delay in BaseStation versions prior to 1.2.3.145 but from this version onwards is in real time.
 * 
 * @author Thomas Wenzlaff
 * @version 0.1
 * @since 11.11.2014
 */
public class MessageTyp {

	@SuppressWarnings("unused")
	private static final Logger LOG = LogManager.getLogger(MessageTyp.class.getName());

	// ID
	//
	// Type
	//
	// Description

	enum IDS {
		// SELECTION CHANGE MESSAGE
		// Generated when the user changes the selected aircraft in BaseStation.
		SEL,

		// NEW ID MESSAGE
		// Generated when an aircraft being tracked sets or changes its
		// callsign.
		ID,

		// NEW AIRCRAFT MESSAGE
		// Generated when the SBS picks up a signal for an aircraft that it
		// isn't
		// currently tracking.
		AIR,

		// STATUS CHANGE MESSAGE
		// Generated when an aircraft's status changes according to the time-out
		// values in the Data Settings menu.
		STA,

		// CLICK MESSAGE
		// Generated when the user double-clicks (or presses return) on an
		// aircraft
		// (i.e. to bring up the aircraft details window).
		CLK,

		// TRANSMISSION MESSAGE
		// Generated by the aircraft. There are eight different MSG types
		MSG;
	}

	/** Die Id der Zeile. */
	private String id;

	public MessageTyp(String id) {
		this.id = id;

	}

	public String getId() {
		return id;
	}

	public void setId(String id) {
		this.id = id;
	}

	public boolean isTransmissionMessage() {
		return this.id.equalsIgnoreCase("MSG") ? true : false;
	}

}
