/*
 * Decompiled with CFR 0.152.
 */
package de.wenzlaff.mathe;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class Standardabweichung
extends JFrame {
    private static final long serialVersionUID = 1L;
    private JTextField[] valueFields = new JTextField[2];
    private JTextField[] probabilityFields = new JTextField[2];
    private double[] values = new double[]{10.0, -5.0};
    private double[] probabilities = new double[]{0.25, 0.75};
    private JPanel dataPanel;

    public Standardabweichung() {
        this.setTitle("Wahrscheinlichkeitsverteilung");
        this.setSize(800, 600);
        this.setDefaultCloseOperation(3);
        this.setLayout(new BorderLayout());
        JPanel inputPanel = this.createInputPanel();
        this.add((Component)inputPanel, "North");
        this.dataPanel = new DataPanel();
        this.add((Component)this.dataPanel, "Center");
    }

    private JPanel createInputPanel() {
        JPanel inputPanel = new JPanel();
        inputPanel.setLayout(new BoxLayout(inputPanel, 1));
        this.valueFields[0] = new JTextField(String.valueOf(this.values[0]));
        inputPanel.add(this.createLabeledField("Wert 1:", this.valueFields[0]));
        this.probabilityFields[0] = new JTextField(String.valueOf(this.probabilities[0]));
        inputPanel.add(this.createLabeledField("Wahrscheinlichkeit 1:", this.probabilityFields[0]));
        this.valueFields[1] = new JTextField(String.valueOf(this.values[1]));
        inputPanel.add(this.createLabeledField("Wert 2:", this.valueFields[1]));
        this.probabilityFields[1] = new JTextField(String.valueOf(this.probabilities[1]));
        inputPanel.add(this.createLabeledField("Wahrscheinlichkeit 2:", this.probabilityFields[1]));
        JButton calculateButton = new JButton("Berechnen");
        calculateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Standardabweichung.this.updateValues();
            }
        });
        inputPanel.add(calculateButton);
        return inputPanel;
    }

    private JPanel createLabeledField(String labelText, JTextField textField) {
        JPanel panel = new JPanel(new FlowLayout(0));
        panel.add(new JLabel(labelText));
        panel.add(textField);
        textField.setColumns(10);
        return panel;
    }

    private void updateValues() {
        try {
            this.values[0] = Double.parseDouble(this.valueFields[0].getText());
            this.values[1] = Double.parseDouble(this.valueFields[1].getText());
            this.probabilities[0] = Double.parseDouble(this.probabilityFields[0].getText());
            this.probabilities[1] = Double.parseDouble(this.probabilityFields[1].getText());
            this.dataPanel.repaint();
        }
        catch (NumberFormatException ex) {
            JOptionPane.showMessageDialog(this, "Bitte g\u00fcltige Zahlen eingeben!");
        }
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(() -> new Standardabweichung().setVisible(true));
    }

    private class DataPanel
    extends JPanel {
        private DataPanel() {
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            Graphics2D g2d = (Graphics2D)g;
            g2d.setColor(Color.WHITE);
            g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
            int startX = 100;
            int startY = 300;
            int barWidth = 100;
            int maxHeight = 200;
            for (int i = 0; i < Standardabweichung.this.values.length; ++i) {
                double scaledHeight = Math.abs(Standardabweichung.this.values[i]) * ((double)maxHeight / 10.0);
                g2d.setColor(Standardabweichung.this.values[i] >= 0.0 ? Color.GREEN : Color.RED);
                g2d.fillRect(startX + i * 150, startY - (int)scaledHeight, barWidth, (int)scaledHeight);
                g2d.setColor(Color.BLACK);
                g2d.drawString(String.format("Wert %d", i + 1), startX + i * 150, startY + 30);
                g2d.drawString(String.format("%.2f\u20ac (%.2f%%)", Standardabweichung.this.values[i], Standardabweichung.this.probabilities[i] * 100.0), startX + i * 150, startY + 50);
            }
            double expectation = this.calculateExpectation();
            double variance = this.calculateVariance(expectation);
            double stdDeviation = Math.sqrt(variance);
            g2d.drawString(String.format("Erwartungswert: %.2f\u20ac", expectation), 50, 50);
            g2d.drawString(String.format("Varianz: %.2f", variance), 50, 70);
            g2d.drawString(String.format("Standardabweichung: %.2f\u20ac", stdDeviation), 50, 90);
        }

        private double calculateExpectation() {
            double sum = 0.0;
            for (int i = 0; i < Standardabweichung.this.values.length; ++i) {
                sum += Standardabweichung.this.values[i] * Standardabweichung.this.probabilities[i];
            }
            return sum;
        }

        private double calculateVariance(double expectation) {
            double variance = 0.0;
            for (int i = 0; i < Standardabweichung.this.values.length; ++i) {
                variance += Math.pow(Standardabweichung.this.values[i] - expectation, 2.0) * Standardabweichung.this.probabilities[i];
            }
            return variance;
        }
    }
}

