/*
 * Decompiled with CFR 0.152.
 */
package de.wenzlaff.mathe;

public class GoldbachsVermutungMin {
    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.println("Bitte eine einzige Zahl gr\u00f6\u00dfer als 2 als Parameter eingeben.");
            return;
        }
        try {
            int grenze = Integer.parseInt(args[0]);
            if (grenze > 2) {
                for (int zahl = 4; zahl <= grenze; zahl += 2) {
                    boolean ergebnis = GoldbachsVermutungMin.pruefeGoldbach(zahl);
                    if (ergebnis) continue;
                    System.err.println("Goldbachsche Vermutung wiederlegt mit: " + zahl);
                    throw new IllegalArgumentException("Die Zahl " + zahl + " l\u00e4sst sich NICHT als Summe zweier Primzahlen darstellen.");
                }
            } else {
                System.out.println("Bitte eine Zahl gr\u00f6\u00dfer als 2 eingeben.");
            }
        }
        catch (NumberFormatException e) {
            System.out.println("Bitte eine g\u00fcltige Zahl als Parameter eingeben.");
        }
    }

    public static boolean pruefeGoldbach(int zahl) {
        for (int i = 2; i <= zahl / 2; ++i) {
            if (!GoldbachsVermutungMin.istPrimzahl(i) || !GoldbachsVermutungMin.istPrimzahl(zahl - i)) continue;
            System.out.println(zahl + " = " + i + " + " + (zahl - i));
            return true;
        }
        return false;
    }

    public static boolean istPrimzahl(int zahl) {
        if (zahl <= 1) {
            return false;
        }
        int i = 2;
        while ((double)i <= Math.sqrt(zahl)) {
            if (zahl % i == 0) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

