/*
 * Decompiled with CFR 0.152.
 */
package de.wenzlaff.mathe;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import org.json.JSONArray;
import org.json.JSONObject;

public class BrierScoreCalculator {
    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.println("Bitte geben Sie den Pfad zur JSON-Datei als Argument an.");
            System.out.println("Beispiel: java BrierScoreCalculator input.json");
            return;
        }
        String jsonFilePath = args[0];
        try {
            String content = new String(Files.readAllBytes(Paths.get(jsonFilePath, new String[0])));
            JSONObject jsonObject = new JSONObject(content);
            JSONArray forecastsArray = jsonObject.getJSONArray("forecasts");
            JSONArray outcomesArray = jsonObject.getJSONArray("outcomes");
            double[] forecasts = new double[forecastsArray.length()];
            int[] outcomes = new int[outcomesArray.length()];
            for (int i = 0; i < forecastsArray.length(); ++i) {
                forecasts[i] = forecastsArray.getDouble(i);
                outcomes[i] = outcomesArray.getInt(i);
            }
            double brierScore = BrierScoreCalculator.berechneBrierScore(forecasts, outcomes);
            BrierScoreCalculator.printResult(forecasts, outcomes, brierScore);
        }
        catch (IOException e) {
            System.out.println("Fehler beim Lesen der JSON-Datei: " + e.getMessage());
        }
        catch (Exception e) {
            System.out.println("Fehler: " + e.getMessage());
        }
    }

    public static double berechneBrierScore(double[] forecasts, int[] outcomes) {
        if (forecasts.length != outcomes.length) {
            throw new IllegalArgumentException("Vorhersagen und Ergebnisse m\u00fcssen die gleiche L\u00e4nge haben.");
        }
        double totalError = 0.0;
        int n = forecasts.length;
        for (int i = 0; i < n; ++i) {
            double error = forecasts[i] - (double)outcomes[i];
            totalError += error * error;
        }
        return totalError / (double)n;
    }

    public static void printResult(double[] forecasts, int[] outcomes, double brierScore) {
        if (forecasts.length != outcomes.length) {
            System.err.println("Fehler: Die Arrays 'forecasts' und 'outcomes' m\u00fcssen dieselbe L\u00e4nge haben.");
            return;
        }
        System.out.printf("%-10s %-15s %-10s%n", "Index", "Vorhersage", "Ergebnis");
        System.out.println("-------------------------------------");
        for (int i = 0; i < forecasts.length; ++i) {
            System.out.printf("%-10d %-15.2f %-10d%n", i + 1, forecasts[i], outcomes[i]);
        }
        System.out.println("-------------------------------------");
        System.out.printf("Brier-Wert: %.4f%n", brierScore);
    }
}

