/*
 * Decompiled with CFR 0.152.
 */
package de.wenzlaff.crypto;

import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PublicKey;
import java.security.spec.ECGenParameterSpec;
import java.util.Arrays;
import javax.crypto.KeyAgreement;

public class ECDH {
    public static void main(String[] args) throws Exception {
        KeyPairGenerator kpg = KeyPairGenerator.getInstance("EC");
        ECGenParameterSpec ecSpec = new ECGenParameterSpec("secp256r1");
        kpg.initialize(ecSpec);
        KeyPair aliceKP = kpg.generateKeyPair();
        KeyAgreement aliceKeyAgree = KeyAgreement.getInstance("ECDH");
        System.out.println("\nAlice erzeugter public Key  = " + String.valueOf(aliceKP.getPublic()));
        System.out.println("\nAlice erzeugter private Key (Hex) = " + ECDH.bytesToHex(aliceKP.getPrivate().getEncoded()));
        aliceKeyAgree.init(aliceKP.getPrivate());
        KeyPair bobKP = kpg.generateKeyPair();
        KeyAgreement bobKeyAgree = KeyAgreement.getInstance("ECDH");
        bobKeyAgree.init(bobKP.getPrivate());
        System.out.println("\nBob erzeugter public Key  = " + String.valueOf(bobKP.getPublic()));
        System.out.println("\nBob erzeugter private Key (Hex)  = " + ECDH.bytesToHex(bobKP.getPrivate().getEncoded()));
        PublicKey alicePubKey = aliceKP.getPublic();
        PublicKey bobPubKey = bobKP.getPublic();
        aliceKeyAgree.doPhase(bobPubKey, true);
        byte[] aliceSharedSecret = aliceKeyAgree.generateSecret();
        bobKeyAgree.doPhase(alicePubKey, true);
        byte[] bobSharedSecret = bobKeyAgree.generateSecret();
        System.out.println("\nSind beide Shared Secrets identisch? " + Arrays.equals(aliceSharedSecret, bobSharedSecret));
        System.out.println("Shared Secret (Hex): " + ECDH.bytesToHex(aliceSharedSecret));
    }

    private static String bytesToHex(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (byte b : bytes) {
            sb.append(String.format("%02x", b));
        }
        return sb.toString();
    }
}

