/*
 * Decompiled with CFR 0.152.
 */
package de.wenzlaff.crypto;

import java.math.BigInteger;
import java.security.SecureRandom;

public class DiffieHellmanKeyTausch {
    public static void main(String[] args) {
        BigInteger p = new BigInteger("23");
        BigInteger g = new BigInteger("5");
        SecureRandom random = new SecureRandom();
        BigInteger a = new BigInteger(5, random);
        BigInteger b = new BigInteger(5, random);
        System.out.println("\u00d6ffentliche Parameter:");
        System.out.println("p = " + String.valueOf(p));
        System.out.println("g = " + String.valueOf(g));
        System.out.println("\nAlice w\u00e4hlt geheime Zahl a = " + String.valueOf(a));
        System.out.println("  Bob w\u00e4hlt geheime Zahl b = " + String.valueOf(b));
        BigInteger A = g.modPow(a, p);
        BigInteger B = g.modPow(b, p);
        System.out.println("\nAlice berechnet und sendet A = g^a mod p = " + String.valueOf(g) + "^" + String.valueOf(a) + " mod " + String.valueOf(p) + " = " + String.valueOf(A));
        System.out.println("  Bob berechnet und sendet B = g^b mod p = " + String.valueOf(g) + "^" + String.valueOf(b) + " mod " + String.valueOf(p) + " = " + String.valueOf(B));
        BigInteger keyAlice = B.modPow(a, p);
        BigInteger keyBob = A.modPow(b, p);
        System.out.println("\nAlice berechnet gemeinsamen Schl\u00fcssel: " + String.valueOf(keyAlice));
        System.out.println("  Bob berechnet gemeinsamen Schl\u00fcssel: " + String.valueOf(keyBob));
        System.out.println("\nSchl\u00fcssel stimmen \u00fcberein: " + keyAlice.equals(keyBob));
    }
}

