package de.wenzlaff.mathe;

/**
 * 
 * @author Thomas Wenzlaff
 *
 */
public class PrimzahlenMin {

	public static void main(String[] args) {
		// Überprüfen, ob genügend Argumente übergeben wurden
		if (args.length != 2) {
			System.out.println("Bitte geben Sie einen Start- und Endwert als Parameter an.");
			return;
		}

		// Eingabeparameter konvertieren
		try {
			int start = Integer.parseInt(args[0]);
			int end = Integer.parseInt(args[1]);

			// Validierung der Eingabe
			if (start > end) {
				System.out.println("Der Startwert muss kleiner oder gleich dem Endwert sein.");
				return;
			}

			// Primzahlen im Bereich finden
			findPrimesInRange(start, end);

		} catch (NumberFormatException e) {
			System.out.println("Bitte geben Sie gültige Ganzzahlen als Start- und Endwert ein.");
		}
	}

	// Methode zur Überprüfung, ob eine Zahl eine Primzahl ist
	public static boolean isPrime(int number) {
		if (number < 2) {
			return false; // Zahlen kleiner als 2 sind keine Primzahlen
		}
		for (int i = 2; i <= Math.sqrt(number); i++) {
			if (number % i == 0) {
				return false; // Zahl ist durch einen anderen Wert als 1 und sich selbst teilbar
			}
		}
		return true;
	}

	// Methode zur Ausgabe der Primzahlen im angegebenen Bereich
	public static void findPrimesInRange(int start, int end) {
		System.out.println("Primzahlen im Bereich von " + start + " bis " + end + ":");
		int anzahl = 0;
		for (int i = start; i <= end; i++) {
			if (isPrime(i)) {
				System.out.print(i + "\n");
				anzahl++;
			}
		}
		System.out.println("Es gibt " + anzahl + " Primzahlen in dem Bereich.");
	}
}
