package de.wenzlaff.mathe;

/**
 * 
 * @author Thomas Wenzlaff
 *
 */
public class LeveneTest {

	public static void main(String[] args) {
		// Beispiel-Datensätze (Gruppen)
		double[][] data = { { 5.2, 7.3, 6.1, 4.8, 5.9 }, // Gruppe 1
				{ 8.7, 7.9, 8.3, 9.1, 8.4 }, // Gruppe 2
				{ 6.2, 6.8, 6.5, 6.4, 6.7 } // Gruppe 3
		};

		// F-Wert des Levene-Tests berechnen
		double fStatistic = calculateLeveneTest(data);

		System.out.println("Levene's F-Wert: " + fStatistic);
	}

	// Methode zur Berechnung des Levene-Tests
	public static double calculateLeveneTest(double[][] data) {
		int totalSampleSize = 0;
		double totalMean = 0.0;

		// Schritt 1: Median jeder Gruppe berechnen und absolute Abweichungen finden
		double[][] deviations = new double[data.length][];
		for (int i = 0; i < data.length; i++) {
			double median = calculateMedian(data[i]);
			deviations[i] = new double[data[i].length];
			for (int j = 0; j < data[i].length; j++) {
				deviations[i][j] = Math.abs(data[i][j] - median);
			}
			totalSampleSize += data[i].length;
		}

		// Schritt 2: Gesamtmittelwert der Abweichungen berechnen
		double grandMean = 0.0;
		for (int i = 0; i < deviations.length; i++) {
			for (int j = 0; j < deviations[i].length; j++) {
				grandMean += deviations[i][j];
			}
		}
		grandMean /= totalSampleSize;

		// Schritt 3: Berechnung der Quadratsummen
		double ssBetweenGroups = 0.0;
		for (int i = 0; i < deviations.length; i++) {
			double groupMean = 0.0;
			for (int j = 0; j < deviations[i].length; j++) {
				groupMean += deviations[i][j];
			}
			groupMean /= deviations[i].length;
			ssBetweenGroups += deviations[i].length * Math.pow(groupMean - grandMean, 2);
		}

		double ssWithinGroups = 0.0;
		for (int i = 0; i < deviations.length; i++) {
			for (int j = 0; j < deviations[i].length; j++) {
				ssWithinGroups += Math.pow(deviations[i][j] - calculateMean(deviations[i]), 2);
			}
		}

		// Schritt 4: Berechnung der F-Statistik
		double dfBetween = deviations.length - 1;
		double dfWithin = totalSampleSize - deviations.length;
		double msBetween = ssBetweenGroups / dfBetween;
		double msWithin = ssWithinGroups / dfWithin;
		return msBetween / msWithin;
	}

	// Hilfsmethode zur Berechnung des Medians eines Arrays
	public static double calculateMedian(double[] values) {
		double[] sorted = values.clone();
		java.util.Arrays.sort(sorted);
		int middle = sorted.length / 2;
		if (sorted.length % 2 == 0) {
			return (sorted[middle - 1] + sorted[middle]) / 2.0;
		} else {
			return sorted[middle];
		}
	}

	// Hilfsmethode zur Berechnung des Mittelwerts eines Arrays
	public static double calculateMean(double[] values) {
		double sum = 0.0;
		for (double v : values) {
			sum += v;
		}
		return sum / values.length;
	}
}
