/*
 * Decompiled with CFR 0.152.
 */
package de.wenzlaff.mathe;

public class PrimzahlenMin {
    public static void main(String[] args) {
        if (args.length != 2) {
            System.out.println("Bitte geben Sie einen Start- und Endwert als Parameter an.");
            return;
        }
        try {
            int start = Integer.parseInt(args[0]);
            int end = Integer.parseInt(args[1]);
            if (start > end) {
                System.out.println("Der Startwert muss kleiner oder gleich dem Endwert sein.");
                return;
            }
            PrimzahlenMin.findPrimesInRange(start, end);
        }
        catch (NumberFormatException e) {
            System.out.println("Bitte geben Sie g\u00fcltige Ganzzahlen als Start- und Endwert ein.");
        }
    }

    public static boolean isPrime(int number) {
        if (number < 2) {
            return false;
        }
        int i = 2;
        while ((double)i <= Math.sqrt(number)) {
            if (number % i == 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static void findPrimesInRange(int start, int end) {
        System.out.println("Primzahlen im Bereich von " + start + " bis " + end + ":");
        int anzahl = 0;
        for (int i = start; i <= end; ++i) {
            if (!PrimzahlenMin.isPrime(i)) continue;
            System.out.print(i + "\n");
            ++anzahl;
        }
        System.out.println("Es gibt " + anzahl + " Primzahlen in dem Bereich.");
    }
}

