/*
 * Decompiled with CFR 0.152.
 */
package de.wenzlaff.mathe;

import java.util.Arrays;

public class LeveneTest {
    public static void main(String[] args) {
        double[][] data = new double[][]{{5.2, 7.3, 6.1, 4.8, 5.9}, {8.7, 7.9, 8.3, 9.1, 8.4}, {6.2, 6.8, 6.5, 6.4, 6.7}};
        double fStatistic = LeveneTest.calculateLeveneTest(data);
        System.out.println("Levene's F-Wert: " + fStatistic);
    }

    public static double calculateLeveneTest(double[][] data) {
        int j;
        int j2;
        int totalSampleSize = 0;
        double totalMean = 0.0;
        double[][] deviations = new double[data.length][];
        for (int i = 0; i < data.length; ++i) {
            double median = LeveneTest.calculateMedian(data[i]);
            deviations[i] = new double[data[i].length];
            for (j2 = 0; j2 < data[i].length; ++j2) {
                deviations[i][j2] = Math.abs(data[i][j2] - median);
            }
            totalSampleSize += data[i].length;
        }
        double grandMean = 0.0;
        for (int i = 0; i < deviations.length; ++i) {
            for (j2 = 0; j2 < deviations[i].length; ++j2) {
                grandMean += deviations[i][j2];
            }
        }
        grandMean /= (double)totalSampleSize;
        double ssBetweenGroups = 0.0;
        for (int i = 0; i < deviations.length; ++i) {
            double groupMean = 0.0;
            for (j = 0; j < deviations[i].length; ++j) {
                groupMean += deviations[i][j];
            }
            ssBetweenGroups += (double)deviations[i].length * Math.pow((groupMean /= (double)deviations[i].length) - grandMean, 2.0);
        }
        double ssWithinGroups = 0.0;
        for (int i = 0; i < deviations.length; ++i) {
            for (j = 0; j < deviations[i].length; ++j) {
                ssWithinGroups += Math.pow(deviations[i][j] - LeveneTest.calculateMean(deviations[i]), 2.0);
            }
        }
        double dfBetween = deviations.length - 1;
        double dfWithin = totalSampleSize - deviations.length;
        double msBetween = ssBetweenGroups / dfBetween;
        double msWithin = ssWithinGroups / dfWithin;
        return msBetween / msWithin;
    }

    public static double calculateMedian(double[] values) {
        double[] sorted = (double[])values.clone();
        Arrays.sort(sorted);
        int middle = sorted.length / 2;
        if (sorted.length % 2 == 0) {
            return (sorted[middle - 1] + sorted[middle]) / 2.0;
        }
        return sorted[middle];
    }

    public static double calculateMean(double[] values) {
        double sum = 0.0;
        for (double v : values) {
            sum += v;
        }
        return sum / (double)values.length;
    }
}

