/*
 * Decompiled with CFR 0.152.
 */
package de.wenzlaff.ki.model;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;

public class KIModelle {
    public static final String JSON_MODEL_DATEI = "src/main/resources/de/wenzlaff/ki/model/ki_modelle.json";

    public List<KIModel> loadModelsFromJson(String filePath) throws IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        String jsonContent = Files.readString(Path.of(filePath, new String[0]));
        return (List)objectMapper.readValue(jsonContent, (TypeReference)new TypeReference<List<KIModel>>(this){});
    }

    public static void main(String[] args) {
        KIModelle kiModelle = new KIModelle();
        try {
            List<KIModel> modelle = kiModelle.loadModelsFromJson(JSON_MODEL_DATEI);
            System.out.println("Liste von " + modelle.size() + " perplexity Modellen aus der JSON-Datei:\n");
            modelle.forEach(modell -> {
                System.out.println(modell);
                System.out.println("-------------------------");
            });
        }
        catch (IOException e) {
            System.err.println("Fehler beim Laden der JSON-Datei: " + e.getMessage());
        }
    }

    static class KIModel {
        public String modell;
        public String beschreibungUndVorteile;
        public String groesse;
        public String veroeffentlichungsdatum;
        public boolean kannFotosErzeugen;

        KIModel() {
        }

        public String toString() {
            return "Modell: " + this.modell + "\nBeschreibung: " + this.beschreibungUndVorteile + "\nGr\u00f6\u00dfe: " + this.groesse + "\nVer\u00f6ffentlichungsdatum: " + this.veroeffentlichungsdatum + "\nKann Fotos erzeugen: " + (this.kannFotosErzeugen ? "Ja" : "Nein") + "\n";
        }
    }
}

