package de.wenzlaff.mathe;

/**
 * 
 * @author Thomas Wenzlaff
 *
 */
public class GoldbachsVermutungMin {

	public static void main(String[] args) {
		if (args.length != 1) {
			System.out.println("Bitte eine einzige Zahl größer als 2 als Parameter eingeben.");
			return;
		}

		try {
			int grenze = Integer.parseInt(args[0]);
			if (grenze > 2) {
				for (int zahl = 4; zahl <= grenze; zahl += 2) {
					boolean ergebnis = pruefeGoldbach(zahl);
					if (ergebnis) {
						// System.out.println("Die Zahl " + zahl + " lässt sich als Summe zweier
						// Primzahlen darstellen.");
					} else {
						System.err.println("Goldbachsche Vermutung wiederlegt mit: " + zahl);
						throw new IllegalArgumentException("Die Zahl " + zahl + " lässt sich NICHT als Summe zweier Primzahlen darstellen.");
					}
				}
			} else {
				System.out.println("Bitte eine Zahl größer als 2 eingeben.");
			}
		} catch (NumberFormatException e) {
			System.out.println("Bitte eine gültige Zahl als Parameter eingeben.");
		}
	}

	// Überprüft, ob eine Zahl als Summe zweier Primzahlen darstellbar ist
	public static boolean pruefeGoldbach(int zahl) {
		for (int i = 2; i <= zahl / 2; i++) {
			if (istPrimzahl(i) && istPrimzahl(zahl - i)) {
				System.out.println(zahl + " = " + i + " + " + (zahl - i));
				return true;
			}
		}
		return false;
	}

	// Überprüft, ob eine Zahl eine Primzahl ist
	public static boolean istPrimzahl(int zahl) {
		if (zahl <= 1)
			return false;
		for (int i = 2; i <= Math.sqrt(zahl); i++) {
			if (zahl % i == 0) {
				return false;
			}
		}
		return true;
	}
}
