/*
 * Decompiled with CFR 0.152.
 */
package de.wenzlaff.mathe;

import java.math.BigInteger;

public class Primzahlen {
    public static void main(String[] args) {
        if (args.length != 2) {
            System.out.println("Bitte geben Sie einen Start- und Endwert als Parameter an.");
            return;
        }
        try {
            BigInteger start = new BigInteger(args[0]);
            BigInteger end = new BigInteger(args[1]);
            if (start.compareTo(end) > 0) {
                System.out.println("Der Startwert muss kleiner oder gleich dem Endwert sein.");
                return;
            }
            Primzahlen.findPrimesInRange(start, end);
        }
        catch (NumberFormatException e) {
            System.out.println("Bitte geben Sie g\u00fcltige Ganzzahlen als Start- und Endwert ein.");
        }
    }

    private static boolean isPrime(BigInteger number) {
        if (number.compareTo(BigInteger.TWO) < 0) {
            return false;
        }
        BigInteger sqrt = Primzahlen.sqrt(number);
        BigInteger i = BigInteger.TWO;
        while (i.compareTo(sqrt) <= 0) {
            if (number.mod(i).equals(BigInteger.ZERO)) {
                return false;
            }
            i = i.add(BigInteger.ONE);
        }
        return true;
    }

    private static void findPrimesInRange(BigInteger start, BigInteger end) {
        System.out.println("Primzahlen im Bereich von " + String.valueOf(start) + " bis " + String.valueOf(end) + ":");
        BigInteger anzahl = BigInteger.ZERO;
        BigInteger i = start;
        while (i.compareTo(end) <= 0) {
            if (Primzahlen.isPrime(i)) {
                System.out.print(String.valueOf(i) + "\n");
                anzahl = anzahl.add(BigInteger.ONE);
            }
            i = i.add(BigInteger.ONE);
        }
        System.out.println("Es gibt " + String.valueOf(anzahl) + " Primzahlen in dem Bereich.");
    }

    private static BigInteger sqrt(BigInteger number) {
        BigInteger x0 = number.divide(BigInteger.TWO);
        BigInteger x1 = x0.add(number.divide(x0)).divide(BigInteger.TWO);
        while (x1.compareTo(x0) < 0) {
            x0 = x1;
            x1 = x0.add(number.divide(x0)).divide(BigInteger.TWO);
        }
        return x0;
    }
}

