/*
 * Decompiled with CFR 0.152.
 */
package de.wenzlaff.mathe;

import java.math.BigInteger;

public class GoldbachsVermutung {
    public static void main(String[] args) {
        if (args.length != 2) {
            System.out.println("Bitte zwei Parameter eingeben: eine obere Grenze und eine Startzahl.");
            return;
        }
        try {
            BigInteger obergrenze = new BigInteger(args[0]);
            BigInteger zwei = BigInteger.valueOf(2L);
            BigInteger startzahl = new BigInteger(args[1]);
            if (obergrenze.compareTo(startzahl) >= 0 && startzahl.compareTo(BigInteger.valueOf(2L)) >= 0 && startzahl.mod(zwei).equals(BigInteger.ZERO)) {
                BigInteger zahl = startzahl;
                while (zahl.compareTo(obergrenze) <= 0) {
                    boolean ergebnis = GoldbachsVermutung.pruefeGoldbach(zahl);
                    if (!ergebnis) {
                        String text = "Die Zahl " + String.valueOf(zahl) + " l\u00e4sst sich NICHT als Summe zweier Primzahlen darstellen.";
                        System.err.println(text);
                        throw new IllegalArgumentException(text);
                    }
                    zahl = zahl.add(zwei);
                }
            } else {
                System.out.println("Bitte eine g\u00fcltige obere Grenze und eine gerade Startzahl gr\u00f6\u00dfer als 2 eingeben.");
            }
        }
        catch (NumberFormatException e) {
            System.out.println("Bitte zwei Parameter eingeben: eine obere Grenze und eine Startzahl.");
        }
    }

    public static boolean pruefeGoldbach(BigInteger zahl) {
        BigInteger zwei;
        BigInteger i = zwei = BigInteger.valueOf(2L);
        while (i.compareTo(zahl.divide(zwei)) <= 0) {
            if (GoldbachsVermutung.istPrimzahl(i) && GoldbachsVermutung.istPrimzahl(zahl.subtract(i))) {
                System.out.println(String.valueOf(zahl) + " = " + String.valueOf(i) + " + " + String.valueOf(zahl.subtract(i)));
                return true;
            }
            i = i.add(BigInteger.ONE);
        }
        return false;
    }

    public static boolean istPrimzahl(BigInteger zahl) {
        if (zahl.compareTo(BigInteger.ONE) <= 0) {
            return false;
        }
        BigInteger sqrtZahl = zahl.sqrt();
        BigInteger i = BigInteger.valueOf(2L);
        while (i.compareTo(sqrtZahl) <= 0) {
            if (zahl.mod(i).equals(BigInteger.ZERO)) {
                return false;
            }
            i = i.add(BigInteger.ONE);
        }
        return true;
    }
}

