/*
 * Decompiled with CFR 0.152.
 */
package de.wenzlaff.linkchecker;

import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.json.JSONObject;

public class Json {
    private static final Logger LOG = LogManager.getLogger(Json.class);

    public static void writeJson(Iterator<Row> iterator, String exportDateiname) {
        ArrayList<JSONObject> aerzte = new ArrayList<JSONObject>();
        HashSet<String> checkNr = new HashSet<String>();
        while (iterator.hasNext()) {
            Row nextRow = iterator.next();
            Iterator cellIterator = nextRow.cellIterator();
            JSONObject json = Json.getSortJSONObject();
            while (cellIterator.hasNext()) {
                String replace;
                Object wert;
                Cell nextCell = (Cell)cellIterator.next();
                int columnIndex = nextCell.getColumnIndex();
                if (columnIndex == 0) {
                    wert = Json.getCellValue(nextCell);
                    if (wert != null) {
                        replace = wert.toString().replace(".0", "");
                        json.put("arztNr", (Object)replace);
                        boolean isVorhanden = checkNr.add(wert.toString());
                        if (!isVorhanden) {
                            String nachricht = "Wert schon vorhanden mit ID: " + replace;
                            LOG.error(nachricht);
                            throw new IllegalArgumentException(nachricht);
                        }
                    } else {
                        json.put("arztNr", (Object)"");
                    }
                }
                if (columnIndex == 1) {
                    json.put("arztTitel", (Object)nextCell.getStringCellValue());
                }
                if (columnIndex == 2) {
                    json.put("arztName", (Object)nextCell.getStringCellValue());
                }
                if (columnIndex == 3) {
                    json.put("arztVorname", (Object)nextCell.getStringCellValue());
                }
                if (columnIndex == 4) {
                    json.put("arztFunktion", (Object)nextCell.getStringCellValue());
                }
                if (columnIndex == 5) {
                    json.put("fachgebiet", (Object)nextCell.getStringCellValue());
                }
                if (columnIndex == 6) {
                    json.put("fachgebiet1", (Object)nextCell.getStringCellValue());
                }
                if (columnIndex == 7) {
                    json.put("fachgebiet2", (Object)nextCell.getStringCellValue());
                }
                if (columnIndex == 8) {
                    json.put("fachgebiet3", (Object)nextCell.getStringCellValue());
                }
                if (columnIndex == 9) {
                    json.put("erwPlan", (Object)nextCell.getStringCellValue());
                }
                if (columnIndex == 10) {
                    json.put("erwNot", (Object)nextCell.getStringCellValue());
                }
                if (columnIndex == 11) {
                    json.put("kindPlan", (Object)nextCell.getStringCellValue());
                }
                if (columnIndex == 12) {
                    json.put("kindNot", (Object)nextCell.getStringCellValue());
                }
                if (columnIndex == 13) {
                    json.put("kleinKindPlan", (Object)nextCell.getStringCellValue());
                }
                if (columnIndex == 14) {
                    json.put("kleinKindNot", (Object)nextCell.getStringCellValue());
                }
                if (columnIndex == 15) {
                    json.put("arztKoSeit", (Object)("" + Json.getCellValue(nextCell)));
                }
                if (columnIndex == 16) {
                    json.put("letzterKontakt", (Object)("" + Json.getCellValue(nextCell)));
                }
                if (columnIndex == 17) {
                    json.put("krhsName", (Object)nextCell.getStringCellValue());
                }
                if (columnIndex == 18) {
                    json.put("krhsStrNr", (Object)nextCell.getStringCellValue());
                }
                if (columnIndex == 19) {
                    wert = Json.getCellValue(nextCell);
                    if (wert != null) {
                        replace = wert.toString().replace(".0", "");
                        json.put("krhsPlz", (Object)replace);
                    } else {
                        json.put("krhsPlz", (Object)"");
                    }
                }
                if (columnIndex == 20) {
                    json.put("krhsOrt", (Object)nextCell.getStringCellValue());
                }
                if (columnIndex == 21) {
                    json.put("krhsTelNr", (Object)nextCell.getStringCellValue());
                }
                if (columnIndex == 22) {
                    json.put("arztNotTel", (Object)nextCell.getStringCellValue());
                }
                if (columnIndex == 23) {
                    json.put("an\u00e4sthesieKooperativ", (Object)nextCell.getStringCellValue());
                }
                if (columnIndex == 24) {
                    json.put("klinik2", (Object)nextCell.getStringCellValue());
                }
                if (columnIndex == 25) {
                    json.put("rab", (Object)nextCell.getStringCellValue());
                }
                if (columnIndex == 26) {
                    json.put("rabStand", (Object)nextCell.getStringCellValue());
                }
                if (columnIndex == 27) {
                    json.put("belegArzt", (Object)nextCell.getStringCellValue());
                }
                if (columnIndex == 28) {
                    json.put("krhsUrl", (Object)nextCell.getStringCellValue());
                }
                if (columnIndex == 29) {
                    json.put("kommentar", (Object)nextCell.getStringCellValue());
                }
                if (columnIndex == 30) {
                    json.put("arztSpezielleKompetenz", (Object)nextCell.getStringCellValue());
                }
                if (columnIndex == 31) {
                    json.put("arztSuchbegriffe", (Object)nextCell.getStringCellValue());
                }
                if (columnIndex == 32) {
                    json.put("betreuer", (Object)nextCell.getStringCellValue());
                }
                if (columnIndex != 33) continue;
                json.put("focus", Json.getCellValue(nextCell));
            }
            if (!Json.isZeileValid(json)) continue;
            aerzte.add(json);
        }
        try (FileWriter file = new FileWriter(exportDateiname);){
            file.write(((Object)aerzte).toString());
            file.flush();
        }
        catch (IOException e) {
            LOG.error(e.getLocalizedMessage());
        }
    }

    private static boolean isZeileValid(JSONObject json) {
        return json.has("arztNr");
    }

    private static JSONObject getSortJSONObject() {
        JSONObject json = new JSONObject();
        try {
            Field neueMap = json.getClass().getDeclaredField("map");
            neueMap.setAccessible(true);
            neueMap.set(json, new LinkedHashMap());
            neueMap.setAccessible(false);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            LOG.error("Error: " + e.getLocalizedMessage());
        }
        return json;
    }

    public static Object getCellValue(Cell cell) {
        if (cell.getCellTypeEnum() == CellType.STRING) {
            return cell.getStringCellValue();
        }
        if (cell.getCellTypeEnum() == CellType.BOOLEAN) {
            return cell.getBooleanCellValue();
        }
        if (cell.getCellTypeEnum() == CellType.NUMERIC) {
            return cell.getNumericCellValue();
        }
        return null;
    }
}

