/*
 * Decompiled with CFR 0.152.
 */
package de.wenzlaff.linkchecker;

import de.wenzlaff.linkchecker.Json;
import de.wenzlaff.linkchecker.Zeile;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellReference;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import picocli.CommandLine;

@CommandLine.Command(name="CheckExcelUrls", mixinStandardHelpOptions=true, version={"CheckExcelUrls 1.1"}, description={"Untersucht eine Exceldatei auf g\u00fcltige URLs in einer Spalte"}, showDefaultValues=true, footer={"@|fg(green) Thomas Wenzlaff|@", "@|fg(red),bold http://www.wenzlaff.info|@"})
public class CheckExcelUrls
implements Callable<Integer> {
    private static final Logger LOG = LogManager.getLogger(CheckExcelUrls.class);
    private static final int TIMEOUT_IN_MILLISEKUNDEN = 5000;
    private static final String TRENNZEICHEN = ", ";
    private static final int SPALTE_ID = 0;
    private static final String STATUS_ERROR = "ERROR";
    private static List<Zeile> zeilen;
    @CommandLine.Option(names={"-s", "--spaltennummer"}, description={"die Spalte Nummer die verwendet werden soll"}, defaultValue="28")
    private int spaltenNumme;
    @CommandLine.Option(names={"-f", "--execldateiname"}, description={"der Dateiname der Exceldatei die untersucht werden soll"}, defaultValue="exceldatei.xlsx")
    private String excelDateiName;
    @CommandLine.Option(names={"-j", "--json"}, description={"Ist das Flag gesetzt wird eine Json Daten Datei erzeugt und keine Online Pr\u00fcfung durchgef\u00fchrt"})
    private boolean generatetJsonData;
    @CommandLine.Option(names={"-d", "--datadateiname"}, description={"der Dateiname der Exportdatei f\u00fcr den Json Export"}, defaultValue="data.json")
    private String jsonDateiName;

    public static void main(String[] args) {
        int exitCode = new CommandLine((Object)new CheckExcelUrls()).execute(args);
        System.exit(exitCode);
    }

    @Override
    public Integer call() throws Exception {
        zeilen = new ArrayList<Zeile>();
        LOG.info("Lese alle Zeilen aus der Excel Datei " + this.excelDateiName);
        LOG.info("Validiere die " + this.spaltenNumme + ". Spalte in der Excel-Datei mit Namen: " + CellReference.convertNumToColString((int)this.spaltenNumme));
        try (FileInputStream inputStream = new FileInputStream(new File(this.excelDateiName));
             XSSFWorkbook workbook = new XSSFWorkbook((InputStream)inputStream);){
            Sheet firstSheet = workbook.getSheetAt(0);
            Iterator iterator = firstSheet.iterator();
            short maxSpalten = firstSheet.getRow(0).getLastCellNum();
            LOG.info("Anzahl der Spalten der Tabelle: " + maxSpalten);
            String sheetName = firstSheet.getSheetName();
            LOG.info("Verwende Blatt " + sheetName);
            if (this.generatetJsonData) {
                Json.writeJson(iterator, this.jsonDateiName);
            } else {
                while (iterator.hasNext()) {
                    this.verarbeiteZeilen(iterator);
                }
            }
        }
        if (this.generatetJsonData) {
            LOG.info("Json Daten Datei " + this.jsonDateiName + " erzeugt.");
        } else {
            LOG.info(zeilen.size() + " gelesene Zeilen aus der Tabelle " + this.excelDateiName);
            LOG.info("Checke nun den Online Status aller URLs ...");
            CheckExcelUrls.checkOnlineStatus();
            LOG.info("Online Check abgeschlossen.");
        }
        return 0;
    }

    private void verarbeiteZeilen(Iterator<Row> iterator) {
        Row nextRow = iterator.next();
        Iterator cellIterator = nextRow.cellIterator();
        Zeile zeile = new Zeile();
        while (cellIterator.hasNext()) {
            Cell nextCell = (Cell)cellIterator.next();
            int columnIndex = nextCell.getColumnIndex();
            if (columnIndex == 0) {
                Object wert = Json.getCellValue(nextCell);
                if (wert != null) {
                    String replace = wert.toString().replace(".0", "");
                    zeile.setId(replace);
                    continue;
                }
                zeile.setId("");
                continue;
            }
            if (columnIndex != this.spaltenNumme) continue;
            zeile.setUrl((String)Json.getCellValue(nextCell));
        }
        try {
            if (CheckExcelUrls.isTitelzeile(zeile)) {
                zeilen.add(zeile);
                LOG.info("Eingelesen " + zeile);
            }
        }
        catch (Exception e) {
            LOG.error("Fehler in Zeile: " + zeile + " Exception:" + e);
        }
    }

    private static boolean isTitelzeile(Zeile zeile) {
        return zeile.getId() != null && !zeile.getId().equals("Nr");
    }

    private static synchronized void checkOnlineStatus() {
        int fehlerNr = 1;
        for (Zeile zeile : zeilen) {
            URL webseite = null;
            try {
                webseite = new URL(zeile.getUrl());
                if (!CheckExcelUrls.getStatus(webseite.toString()).contains(STATUS_ERROR)) continue;
                LOG.error("Fehler Nr. " + fehlerNr + " ZeilenId: " + zeile.getId() + "\t" + CheckExcelUrls.getStatus(webseite.toString()));
                ++fehlerNr;
            }
            catch (Exception e) {
                LOG.error("Fehler Nr. " + fehlerNr + " Fehler " + e.getMessage() + " in Zeile: " + zeile + " mit URL: " + webseite);
                ++fehlerNr;
            }
        }
    }

    private static String getStatus(String url) {
        Object result = "";
        try {
            URL siteURL = new URL(url);
            HttpURLConnection connection = (HttpURLConnection)siteURL.openConnection();
            connection.setRequestMethod("GET");
            connection.setConnectTimeout(5000);
            connection.connect();
            int code = connection.getResponseCode();
            result = code == 200 || code <= 305 ? " OK, " + code + TRENNZEICHEN : (code >= 400 || code <= 505 ? " ERROR, " + code + TRENNZEICHEN + url : TRENNZEICHEN + code + TRENNZEICHEN);
        }
        catch (Exception e) {
            result = " ERROR,    , " + e.getMessage();
        }
        return result;
    }
}

