/*
 * Decompiled with CFR 0.152.
 */
package de.wenzlaff.linkchecker;

import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.json.JSONObject;

public class Json {
    private static final Logger LOG = LogManager.getLogger(Json.class);

    public static void writeJson(Iterator<Row> iterator, String exportDateiname) {
        ArrayList<JSONObject> aerzte = new ArrayList<JSONObject>();
        HashSet<String> checkNr = new HashSet<String>();
        while (iterator.hasNext()) {
            Row nextRow = iterator.next();
            Iterator<Cell> cellIterator = nextRow.cellIterator();
            JSONObject json = Json.getSortJSONObject();
            while (cellIterator.hasNext()) {
                String replace;
                Object wert;
                Cell nextCell = cellIterator.next();
                int columnIndex = nextCell.getColumnIndex();
                if (columnIndex == 0) {
                    wert = Json.getCellValue(nextCell);
                    if (wert != null) {
                        replace = wert.toString().replace(".0", "");
                        json.put("arztNr", replace);
                        boolean isVorhanden = checkNr.add(wert.toString());
                        if (!isVorhanden) {
                            String nachricht = "Wert schon vorhanden mit ID: " + replace;
                            LOG.error(nachricht);
                            throw new IllegalArgumentException(nachricht);
                        }
                    } else {
                        json.put("arztNr", "");
                    }
                }
                if (columnIndex == 1) {
                    json.put("arztTitel", nextCell.getStringCellValue());
                }
                if (columnIndex == 2) {
                    json.put("arztName", nextCell.getStringCellValue());
                }
                if (columnIndex == 3) {
                    json.put("arztVorname", nextCell.getStringCellValue());
                }
                if (columnIndex == 4) {
                    json.put("arztFunktion", nextCell.getStringCellValue());
                }
                if (columnIndex == 5) {
                    json.put("fachgebiet", nextCell.getStringCellValue());
                }
                if (columnIndex == 6) {
                    json.put("fachgebiet1", nextCell.getStringCellValue());
                }
                if (columnIndex == 7) {
                    json.put("fachgebiet2", nextCell.getStringCellValue());
                }
                if (columnIndex == 8) {
                    json.put("fachgebiet3", nextCell.getStringCellValue());
                }
                if (columnIndex == 9) {
                    json.put("erwPlan", nextCell.getStringCellValue());
                }
                if (columnIndex == 10) {
                    json.put("erwNot", nextCell.getStringCellValue());
                }
                if (columnIndex == 11) {
                    json.put("kindPlan", nextCell.getStringCellValue());
                }
                if (columnIndex == 12) {
                    json.put("kindNot", nextCell.getStringCellValue());
                }
                if (columnIndex == 13) {
                    json.put("kleinKindPlan", nextCell.getStringCellValue());
                }
                if (columnIndex == 14) {
                    json.put("kleinKindNot", nextCell.getStringCellValue());
                }
                if (columnIndex == 15) {
                    json.put("arztKoSeit", "" + Json.getCellValue(nextCell));
                }
                if (columnIndex == 16) {
                    json.put("letzterKontakt", "" + Json.getCellValue(nextCell));
                }
                if (columnIndex == 17) {
                    json.put("krhsName", nextCell.getStringCellValue());
                }
                if (columnIndex == 18) {
                    json.put("krhsStrNr", nextCell.getStringCellValue());
                }
                if (columnIndex == 19) {
                    wert = Json.getCellValue(nextCell);
                    if (wert != null) {
                        replace = wert.toString().replace(".0", "");
                        json.put("krhsPlz", replace);
                    } else {
                        json.put("krhsPlz", "");
                    }
                }
                if (columnIndex == 20) {
                    json.put("krhsOrt", nextCell.getStringCellValue());
                }
                if (columnIndex == 21) {
                    json.put("krhsTelNr", nextCell.getStringCellValue());
                }
                if (columnIndex == 22) {
                    json.put("arztNotTel", nextCell.getStringCellValue());
                }
                if (columnIndex == 23) {
                    json.put("an\u00e4sthesieKooperativ", nextCell.getStringCellValue());
                }
                if (columnIndex == 24) {
                    json.put("klinik2", nextCell.getStringCellValue());
                }
                if (columnIndex == 25) {
                    json.put("rab", nextCell.getStringCellValue());
                }
                if (columnIndex == 26) {
                    json.put("rabStand", nextCell.getStringCellValue());
                }
                if (columnIndex == 27) {
                    json.put("belegArzt", nextCell.getStringCellValue());
                }
                if (columnIndex == 28) {
                    json.put("krhsUrl", nextCell.getStringCellValue());
                }
                if (columnIndex == 29) {
                    json.put("kommentar", nextCell.getStringCellValue());
                }
                if (columnIndex == 30) {
                    json.put("arztSpezielleKompetenz", nextCell.getStringCellValue());
                }
                if (columnIndex == 31) {
                    json.put("arztSuchbegriffe", nextCell.getStringCellValue());
                }
                if (columnIndex == 32) {
                    json.put("betreuer", nextCell.getStringCellValue());
                }
                if (columnIndex != 33) continue;
                json.put("focus", Json.getCellValue(nextCell));
            }
            if (!Json.isZeileValid(json)) continue;
            aerzte.add(json);
        }
        try (FileWriter file = new FileWriter(exportDateiname);){
            file.write(((Object)aerzte).toString());
            file.flush();
        }
        catch (IOException e) {
            LOG.error(e.getLocalizedMessage());
        }
    }

    private static boolean isZeileValid(JSONObject json) {
        return json.has("arztNr");
    }

    private static JSONObject getSortJSONObject() {
        JSONObject json = new JSONObject();
        try {
            Field neueMap = json.getClass().getDeclaredField("map");
            neueMap.setAccessible(true);
            neueMap.set(json, new LinkedHashMap());
            neueMap.setAccessible(false);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            LOG.error("Error: " + e.getLocalizedMessage());
        }
        return json;
    }

    public static Object getCellValue(Cell cell) {
        if (cell.getCellTypeEnum() == CellType.STRING) {
            return cell.getStringCellValue();
        }
        if (cell.getCellTypeEnum() == CellType.BOOLEAN) {
            return cell.getBooleanCellValue();
        }
        if (cell.getCellTypeEnum() == CellType.NUMERIC) {
            return cell.getNumericCellValue();
        }
        return null;
    }
}

