/*
 * Decompiled with CFR 0.152.
 */
package de.wenzlaff.linkchecker;

import de.wenzlaff.linkchecker.Zeile;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellReference;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class CheckExcelUrls {
    private static final int TIMEOUT_IN_MILLISEKUNDEN = 5000;
    private static final String TRENNZEICHEN = ", ";
    private static final int SPALTE_ID = 0;
    private static final String STATUS_ERROR = "ERROR";
    private static List<Zeile> zeilen;

    public static void main(String[] args) throws Exception {
        if (args.length != 2) {
            CheckExcelUrls.hilfeTextAusgeben();
            return;
        }
        int spaltenNummer = Integer.valueOf(args[0]);
        String excelDateiName = args[1];
        zeilen = new ArrayList<Zeile>();
        System.out.println("Lese alle Zeilen aus der Excel Datei " + excelDateiName);
        System.out.println("Validiere die " + spaltenNummer + ". Spalte in der Excel-Datei mit Namen: " + CellReference.convertNumToColString((int)spaltenNummer));
        try (FileInputStream inputStream = new FileInputStream(new File(excelDateiName));
             XSSFWorkbook workbook = new XSSFWorkbook((InputStream)inputStream);){
            Sheet firstSheet = workbook.getSheetAt(0);
            Iterator iterator = firstSheet.iterator();
            short maxSpalten = firstSheet.getRow(0).getLastCellNum();
            System.out.println("Anzahl der Spalten der Tabelle: " + maxSpalten);
            String sheetName = firstSheet.getSheetName();
            System.out.println("Verwende Blatt " + sheetName);
            while (iterator.hasNext()) {
                Row nextRow = (Row)iterator.next();
                Iterator cellIterator = nextRow.cellIterator();
                Zeile zeile = new Zeile();
                while (cellIterator.hasNext()) {
                    Cell nextCell = (Cell)cellIterator.next();
                    int columnIndex = nextCell.getColumnIndex();
                    if (columnIndex == 0) {
                        Object wert = CheckExcelUrls.getCellValue(nextCell);
                        if (wert != null) {
                            String replace = wert.toString().replace(".0", "");
                            zeile.setId(replace);
                            continue;
                        }
                        zeile.setId("");
                        continue;
                    }
                    if (columnIndex != spaltenNummer) continue;
                    zeile.setUrl((String)CheckExcelUrls.getCellValue(nextCell));
                }
                try {
                    if (!CheckExcelUrls.isTitelzeile(zeile)) continue;
                    zeilen.add(zeile);
                    System.out.println("Eingelesen " + zeile);
                }
                catch (Exception e) {
                    System.err.println("Fehler in Zeile: " + zeile + " Exception:" + e);
                }
            }
        }
        System.out.println(zeilen.size() + " gelesene Zeilen aus der Tabelle " + excelDateiName);
        System.out.println("Checke nun den Online Status aller URLs ...");
        CheckExcelUrls.checkOnlineStatus();
        System.out.println("Online Check abgeschlossen.");
    }

    private static boolean isTitelzeile(Zeile zeile) {
        return zeile.getId() != null && !zeile.getId().equals("Nr");
    }

    private static void hilfeTextAusgeben() {
        System.out.println("Programmaufruf: de.wenzlaff.linkchecker.CheckExcelUrls [Spalte Nummer von links mit den URLs die \u00c3\u00bcberpr\u00c3\u00bcft werden soll] [Excel Dateiname] ");
        System.out.println("Aufruf z.B.: de.wenzlaff.linkchecker.CheckExcelUrls 28 exceldatei.xlsx");
    }

    private static synchronized void checkOnlineStatus() {
        int fehlerNr = 1;
        for (Zeile zeile : zeilen) {
            URL webseite = null;
            try {
                webseite = new URL(zeile.getUrl());
                if (!CheckExcelUrls.getStatus(webseite.toString()).contains(STATUS_ERROR)) continue;
                System.err.println("Fehler Nr. " + fehlerNr + " ZeilenId: " + zeile.getId() + "\t" + CheckExcelUrls.getStatus(webseite.toString()));
                ++fehlerNr;
            }
            catch (Exception e) {
                System.err.println("Fehler Nr. " + fehlerNr + " Fehler " + e.getMessage() + " in Zeile: " + zeile + " mit URL: " + webseite);
                ++fehlerNr;
            }
        }
    }

    private static String getStatus(String url) {
        String result = "";
        try {
            URL siteURL = new URL(url);
            HttpURLConnection connection = (HttpURLConnection)siteURL.openConnection();
            connection.setRequestMethod("GET");
            connection.setConnectTimeout(5000);
            connection.connect();
            int code = connection.getResponseCode();
            result = code == 200 || code <= 305 ? " OK, " + code + TRENNZEICHEN : (code >= 400 || code <= 505 ? " ERROR, " + code + TRENNZEICHEN + url : TRENNZEICHEN + code + TRENNZEICHEN);
        }
        catch (Exception e) {
            result = " ERROR,    , " + e.getMessage();
        }
        return result;
    }

    private static Object getCellValue(Cell cell) {
        if (cell.getCellTypeEnum() == CellType.STRING) {
            return cell.getStringCellValue();
        }
        if (cell.getCellTypeEnum() == CellType.BOOLEAN) {
            return cell.getBooleanCellValue();
        }
        if (cell.getCellTypeEnum() == CellType.NUMERIC) {
            return cell.getNumericCellValue();
        }
        return null;
    }
}

