/*
 * Decompiled with CFR 0.152.
 */
package de.wenzlaff.blockchain;

import java.io.IOException;
import java.math.BigDecimal;
import java.net.ConnectException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.web3j.crypto.Credentials;
import org.web3j.crypto.WalletUtils;
import org.web3j.protocol.Web3j;
import org.web3j.protocol.Web3jService;
import org.web3j.protocol.core.DefaultBlockParameter;
import org.web3j.protocol.core.DefaultBlockParameterName;
import org.web3j.protocol.core.methods.response.EthGasPrice;
import org.web3j.protocol.core.methods.response.EthGetBalance;
import org.web3j.protocol.core.methods.response.TransactionReceipt;
import org.web3j.protocol.core.methods.response.Web3ClientVersion;
import org.web3j.protocol.http.HttpService;
import org.web3j.utils.Convert;
import picocli.CommandLine;

@CommandLine.Command(name="Transfer", mixinStandardHelpOptions=true, version={"Transfer 1.0"}, description={"Eine transaktion ausf\u00fchren."}, footer={"@|fg(green) Thomas Wenzlaff|@", "@|fg(red),bold http://www.wenzlaff.info|@"})
public class Transfer
implements Callable<Integer> {
    private static final Logger LOG = LogManager.getLogger(Transfer.class);
    @CommandLine.Option(names={"-s", "--server"}, description={"die URL des RPC (Ganache) Servers"}, defaultValue="http://127.0.0.1:7545")
    private static String rpcServerUrl;
    @CommandLine.Option(names={"-p", "--password"}, description={"das Passwort aus der Quell-Wallet"})
    private static String walletPasswordQuelle;
    @CommandLine.Option(names={"-d", "--walletDateiname"}, description={"der Dateiname des Json Wallet der Quelle"})
    private static String walletJsonDateinameQuelle;
    @CommandLine.Option(names={"-z", "--zielAdresse"}, description={"die Ziel Adresse"})
    private static String zielAdresseJson;
    @CommandLine.Option(names={"-b", "--betrag"}, description={"derBetrag der \u00fcberwiesen werden soll in Ether"})
    private static double ueberweiseBetragInEther;

    public static void main(String[] args) throws Exception {
        int exitCode = new CommandLine((Object)new Transfer()).execute(args);
        System.exit(exitCode);
    }

    private void send(Web3j web3, Credentials credentials, String zielAdresse, double ether) throws Exception {
        LOG.info("Send " + ether + " Ether  = " + Convert.toWei((BigDecimal)BigDecimal.valueOf(ether), (Convert.Unit)Convert.Unit.ETHER) + " WEI ...");
        TransactionReceipt transactionReceipt = (TransactionReceipt)org.web3j.tx.Transfer.sendFunds((Web3j)web3, (Credentials)credentials, (String)zielAdresse, (BigDecimal)BigDecimal.valueOf(ether), (Convert.Unit)Convert.Unit.ETHER).send();
        LOG.info("Betrag von Adresse: " + transactionReceipt.getFrom());
        LOG.info("In Block Nummer   : " + transactionReceipt.getBlockNumber());
        this.request(web3, zielAdresse);
    }

    private Web3j getInstance(String blockchainServerUrl) {
        Web3j web3 = Web3j.build((Web3jService)new HttpService(rpcServerUrl));
        LOG.info("OK, verbunden mit Blockchain " + blockchainServerUrl + " ...");
        return web3;
    }

    private void request(Web3j web3, String addresse) throws IOException, InterruptedException, ExecutionException {
        Web3ClientVersion clientVersion = null;
        try {
            clientVersion = (Web3ClientVersion)web3.web3ClientVersion().send();
        }
        catch (ConnectException e) {
            LOG.error("Die Blockchain ist nicht erreichbar. Starten vergessen? Oder URL oder Port falsch?");
            throw e;
        }
        LOG.debug("Client Version: " + clientVersion.getWeb3ClientVersion());
        EthGasPrice gasPrice = (EthGasPrice)web3.ethGasPrice().send();
        LOG.debug("Default Gas Preis: " + gasPrice.getGasPrice());
        LOG.info("Addresse:           " + addresse);
        LOG.info("Bestand:            " + Convert.fromWei((String)((EthGetBalance)web3.ethGetBalance(addresse, (DefaultBlockParameter)DefaultBlockParameterName.LATEST).send()).getBalance().toString(), (Convert.Unit)Convert.Unit.ETHER) + " Ether =  " + Convert.fromWei((String)((EthGetBalance)web3.ethGetBalance(addresse, (DefaultBlockParameter)DefaultBlockParameterName.LATEST).send()).getBalance().toString(), (Convert.Unit)Convert.Unit.GWEI) + " GWEI");
    }

    @Override
    public Integer call() throws Exception {
        LOG.info("Kopiere " + ueberweiseBetragInEther + " Ether von Json Wallet Datei --> " + walletJsonDateinameQuelle);
        LOG.info("nach Ziel Konto Adresse --> " + zielAdresseJson);
        Transfer transfer = new Transfer();
        Web3j web3 = transfer.getInstance(rpcServerUrl);
        LOG.info("Ziel Addresse Bestand: ");
        transfer.request(web3, zielAdresseJson);
        Credentials jsonWalletCredentials = WalletUtils.loadCredentials((String)walletPasswordQuelle, (String)walletJsonDateinameQuelle);
        LOG.info("Von Json Wallet Adresse Bestand: ");
        transfer.request(web3, jsonWalletCredentials.getAddress());
        transfer.send(web3, jsonWalletCredentials, zielAdresseJson, ueberweiseBetragInEther);
        return 0;
    }
}

