/*
 * Decompiled with CFR 0.152.
 */
package de.wenzlaff.blockchain;

import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.web3j.crypto.Credentials;
import org.web3j.crypto.WalletUtils;

public class LocalWallet {
    private static final Logger LOG = LogManager.getLogger(LocalWallet.class);

    public static void main(String[] args) throws Exception {
        if (args.length == 0 || args[0].isEmpty()) {
            LOG.error("Passwort nicht als Programmparameter gesetzt!");
            return;
        }
        String password = args[0];
        LocalWallet localWallet = new LocalWallet();
        String jsonWalletFileName = localWallet.createWallet(password);
        LOG.info("Erzeugte Wallet Adresse: " + localWallet.readJsonWallet(jsonWalletFileName).get((Object)"address"));
        Credentials credentials = WalletUtils.loadCredentials((String)password, (String)jsonWalletFileName);
        LOG.info("Credential: " + credentials.getAddress());
        LOG.info("Private Key: " + credentials.getEcKeyPair().getPrivateKey());
        LOG.info("Public Key : " + credentials.getEcKeyPair().getPublicKey());
    }

    private String createWallet(String password) throws Exception {
        String generateWalletFileName = WalletUtils.generateNewWalletFile((String)password, (File)new File("."));
        LOG.info("Wallet mit Passwort: " + password + " in Json Datei: " + generateWalletFileName + " erzeugt.");
        return generateWalletFileName;
    }

    private JSONObject readJsonWallet(String walletDateiName) {
        JSONObject wallet = null;
        try (FileReader reader = new FileReader(walletDateiName);){
            Object obj = new JSONParser().parse((Reader)reader);
            wallet = (JSONObject)obj;
        }
        catch (Exception e) {
            LOG.error("Fehler beim einlesen des Wallets", (Throwable)e);
        }
        return wallet;
    }
}

