/*
 * Decompiled with CFR 0.152.
 */
package de.weltraumschaf.speakingurl;

final class Validator {
    Validator() {
    }

    <T> T notNull(T validated, String name) {
        this.validateName(name);
        if (null == validated) {
            throw new NullPointerException(String.format("Parameter '%s' must not be null!", name));
        }
        return validated;
    }

    String notEmpty(String validated, String name) {
        this.notNull(validated, name);
        if (validated.trim().isEmpty()) {
            throw new IllegalArgumentException(String.format("Parameter '%s' must not be empty!", name));
        }
        return validated;
    }

    int notNegative(int validated, String name) {
        this.validateName(name);
        if (validated < 0) {
            throw new IllegalArgumentException(String.format("Parameter '%s' must not be negative (was '%d')!", name, validated));
        }
        return validated;
    }

    private void validateName(String name) {
        if (null == name) {
            throw new NullPointerException("The name must not be null!");
        }
        if (name.trim().isEmpty()) {
            throw new IllegalArgumentException("The name must not be empty!");
        }
    }
}

