/*
 * Decompiled with CFR 0.152.
 */
package de.weltraumschaf.speakingurl;

import de.weltraumschaf.speakingurl.Language;
import de.weltraumschaf.speakingurl.Validator;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

final class SymbolMapper {
    private static final Map<Language, Map<String, String>> MAPPING;
    private final Validator validator = new Validator();

    SymbolMapper() {
    }

    boolean knowsSymbol(Language language, String symbol) {
        if (MAPPING.containsKey((Object)this.validator.notNull(language, "language"))) {
            return MAPPING.get((Object)language).containsKey(this.validator.notNull(symbol, "symbol"));
        }
        return false;
    }

    String mapSymbol(Language language, String symbol) {
        if (this.knowsSymbol(language, symbol)) {
            return MAPPING.get((Object)language).get(symbol);
        }
        throw new IllegalArgumentException(String.format("Unknown symbol '%s' for language %s!", new Object[]{symbol, language}));
    }

    static {
        HashMap tmp = new HashMap();
        HashMap<String, String> arabic = new HashMap<String, String>();
        arabic.put("\u2206", "delta");
        arabic.put("\u221e", "la-nihaya");
        arabic.put("\u2665", "hob");
        arabic.put("&", "wa");
        arabic.put("|", "aw");
        arabic.put("<", "aqal-men");
        arabic.put(">", "akbar-men");
        arabic.put("\u2211", "majmou");
        arabic.put("\u00a4", "omla");
        tmp.put(Language.ARABIC, Collections.unmodifiableMap(arabic));
        HashMap<String, String> german = new HashMap<String, String>();
        german.put("\u2206", "delta");
        german.put("\u221e", "unendlich");
        german.put("\u2665", "Liebe");
        german.put("&", "und");
        german.put("|", "oder");
        german.put("<", "kleiner als");
        german.put(">", "groesser als");
        german.put("\u2211", "Summe von");
        german.put("\u00a4", "Waehrung");
        tmp.put(Language.GERMAN, Collections.unmodifiableMap(german));
        HashMap<String, String> netherland = new HashMap<String, String>();
        netherland.put("\u2206", "delta");
        netherland.put("\u221e", "oneindig");
        netherland.put("\u2665", "liefde");
        netherland.put("&", "en");
        netherland.put("|", "of");
        netherland.put("<", "kleiner dan");
        netherland.put(">", "groter dan");
        netherland.put("\u2211", "som");
        netherland.put("\u00a4", "valuta");
        tmp.put(Language.NETHERLAND, Collections.unmodifiableMap(netherland));
        HashMap<String, String> english = new HashMap<String, String>();
        english.put("\u2206", "delta");
        english.put("\u221e", "infinity");
        english.put("\u2665", "love");
        english.put("&", "and");
        english.put("|", "or");
        english.put("<", "less than");
        english.put(">", "greater than");
        english.put("\u2211", "sum");
        english.put("\u00a4", "currency");
        tmp.put(Language.ENGLISH, Collections.unmodifiableMap(english));
        HashMap<String, String> spanish = new HashMap<String, String>();
        spanish.put("\u2206", "delta");
        spanish.put("\u221e", "infinito");
        spanish.put("\u2665", "amor");
        spanish.put("&", "y");
        spanish.put("|", "u");
        spanish.put("<", "menos que");
        spanish.put(">", "mas que");
        spanish.put("\u2211", "suma de los");
        spanish.put("\u00a4", "moneda");
        tmp.put(Language.SPANISH, Collections.unmodifiableMap(spanish));
        HashMap<String, String> french = new HashMap<String, String>();
        french.put("\u2206", "delta");
        french.put("\u221e", "infiniment");
        french.put("\u2665", "Amour");
        french.put("&", "et");
        french.put("|", "ou");
        french.put("<", "moins que");
        french.put(">", "superieure a");
        french.put("\u2211", "somme des");
        french.put("\u00a4", "monnaie");
        tmp.put(Language.FRENCH, Collections.unmodifiableMap(french));
        HashMap<String, String> portuguese = new HashMap<String, String>();
        portuguese.put("\u2206", "delta");
        portuguese.put("\u221e", "infinito");
        portuguese.put("\u2665", "amor");
        portuguese.put("&", "e");
        portuguese.put("|", "ou");
        portuguese.put("<", "menor que");
        portuguese.put(">", "maior que");
        portuguese.put("\u2211", "soma");
        portuguese.put("\u00a4", "moeda");
        tmp.put(Language.PORTUGUESE, Collections.unmodifiableMap(portuguese));
        HashMap<String, String> russian = new HashMap<String, String>();
        russian.put("\u2206", "delta");
        russian.put("\u221e", "beskonechno");
        russian.put("\u2665", "lubov");
        russian.put("&", "i");
        russian.put("|", "ili");
        russian.put("<", "menshe");
        russian.put(">", "bolshe");
        russian.put("\u2211", "summa");
        russian.put("\u00a4", "valjuta");
        tmp.put(Language.RUSSIAN, Collections.unmodifiableMap(russian));
        HashMap<String, String> czech = new HashMap<String, String>();
        czech.put("\u2206", "delta");
        czech.put("\u221e", "nekonecno");
        czech.put("\u2665", "laska");
        czech.put("&", "a");
        czech.put("|", "nebo");
        czech.put("<", "mene jako");
        czech.put(">", "vice jako");
        czech.put("\u2211", "soucet");
        czech.put("\u00a4", "mena");
        tmp.put(Language.CZECH, Collections.unmodifiableMap(czech));
        HashMap<String, String> swedish = new HashMap<String, String>();
        swedish.put("\u2206", "delta");
        swedish.put("\u221e", "nekonecno");
        swedish.put("\u2665", "laska");
        swedish.put("&", "a");
        swedish.put("|", "alebo");
        swedish.put("<", "menej ako");
        swedish.put(">", "viac ako");
        swedish.put("\u2211", "sucet");
        swedish.put("\u00a4", "mena");
        tmp.put(Language.SWEDISH, Collections.unmodifiableMap(swedish));
        HashMap<String, String> vietnamese = new HashMap<String, String>();
        vietnamese.put("\u2206", "delta");
        vietnamese.put("\u221e", "vo cuc");
        vietnamese.put("\u2665", "yeu");
        vietnamese.put("&", "va");
        vietnamese.put("|", "hoac");
        vietnamese.put("<", "nho hon");
        vietnamese.put(">", "lon hon");
        vietnamese.put("\u2211", "tong");
        vietnamese.put("\u00a4", "tien te");
        tmp.put(Language.VIETNAMESE, Collections.unmodifiableMap(vietnamese));
        MAPPING = Collections.unmodifiableMap(tmp);
    }
}

