/*
 * Decompiled with CFR 0.152.
 */
package de.weltraumschaf.speakingurl;

import de.weltraumschaf.speakingurl.Language;
import de.weltraumschaf.speakingurl.Options;
import de.weltraumschaf.speakingurl.SlugImplementation;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public interface Slug {
    public String get(String var1);

    public String get(String var1, String var2);

    public String separator();

    public Language lang();

    public boolean maintainCase();

    public boolean titleCase();

    public Set<String> titleCaseExclude();

    public int truncate();

    public boolean uric();

    public boolean uricNoSlash();

    public boolean mark();

    public Map<String, String> getCustom();

    public static final class Builder {
        private final Options options = new Options();

        private Builder() {
        }

        public static Builder newBuiler() {
            return new Builder();
        }

        public Slug create() {
            return new SlugImplementation(this.options.copy());
        }

        public Builder separator(String separator) {
            this.options.separator(separator);
            return this;
        }

        public Builder lang(Language lang) {
            this.options.language(lang);
            return this;
        }

        public Builder maintainCase(boolean maintainCase) {
            this.options.maintainCase(maintainCase);
            return this;
        }

        public Builder titleCase(boolean titleCase) {
            this.options.titleCase(titleCase);
            return this;
        }

        public Builder titleCaseExclude(String ... titleCaseExclude) {
            this.titleCaseExclude(new HashSet<String>(Arrays.asList(titleCaseExclude)));
            return this;
        }

        public Builder titleCaseExclude(Set<String> titleCaseExclude) {
            this.options.titleCaseExclude(Collections.unmodifiableSet(titleCaseExclude));
            return this;
        }

        public Builder truncate(int truncate) {
            this.options.truncate(truncate);
            return this;
        }

        public Builder uric(boolean uric) {
            this.options.uric(uric);
            return this;
        }

        public Builder uricNoSlash(boolean uricNoSlash) {
            this.options.uricWithoutSlash(uricNoSlash);
            return this;
        }

        public Builder mark(boolean mark) {
            this.options.mark(mark);
            return this;
        }

        public Builder custom(Map<String, String> custom) {
            this.options.custom(custom);
            return this;
        }
    }
}

