/*
 * Decompiled with CFR 0.152.
 */
package de.weltraumschaf.speakingurl;

import de.weltraumschaf.speakingurl.Language;
import de.weltraumschaf.speakingurl.Validator;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

final class LanguageCharacterMapper {
    private static final Language DEFAULT = Language.ENGLISH;
    private static final Map<Language, Map<String, String>> MAPPING = new HashMap<Language, Map<String, String>>();
    private final Validator validator = new Validator();

    LanguageCharacterMapper() {
    }

    boolean knowsCharacter(Language lang, String ch) {
        this.validator.notNull(lang, "validator");
        if (MAPPING.containsKey((Object)lang)) {
            return MAPPING.get((Object)lang).containsKey(ch);
        }
        return MAPPING.get((Object)DEFAULT).containsKey(ch);
    }

    String mapCharacter(Language lang, String ch) {
        if (this.knowsCharacter(lang, ch)) {
            return MAPPING.get((Object)lang).get(ch);
        }
        throw new IllegalArgumentException(String.format("Unknown character '%s' for language %s!", new Object[]{ch, lang}));
    }

    static {
        MAPPING.put(Language.ENGLISH, Collections.emptyMap());
        HashMap<String, String> swedish = new HashMap<String, String>();
        swedish.put("\u00e4", "a");
        swedish.put("\u00c4", "A");
        MAPPING.put(Language.SWEDISH, Collections.unmodifiableMap(swedish));
    }
}

