/*
 * Decompiled with CFR 0.152.
 */
package de.weltraumschaf.freemarkerdown;

import de.weltraumschaf.commons.validate.Validate;
import de.weltraumschaf.freemarkerdown.PreProcessor;
import de.weltraumschaf.freemarkerdown.PreProcessorApplier;
import java.util.StringTokenizer;
import net.jcip.annotations.NotThreadSafe;

@NotThreadSafe
final class PreProcessorApplierImpl
implements PreProcessorApplier {
    private static final String START_TOKEN = "<?";
    private static final String END_TOKEN = "?>";

    PreProcessorApplierImpl() {
    }

    @Override
    public String apply(String subject, PreProcessor processor) {
        Validate.notNull((Object)subject, (String)"subject");
        Validate.notNull((Object)processor, (String)"processor");
        String startToken = START_TOKEN + processor.getTarget();
        StringTokenizer tokenizer = new StringTokenizer(subject, " \t\n\r\f", true);
        StringBuilder buffer = new StringBuilder();
        StringBuilder instructionBuffer = new StringBuilder();
        boolean insideInstruction = false;
        while (tokenizer.hasMoreTokens()) {
            String current = tokenizer.nextToken();
            if (startToken.equals(current)) {
                insideInstruction = true;
                continue;
            }
            if (END_TOKEN.equals(current) && insideInstruction) {
                insideInstruction = false;
                buffer.append(processor.process(instructionBuffer.toString()));
                instructionBuffer = new StringBuilder();
                continue;
            }
            if (insideInstruction) {
                instructionBuffer.append(current);
                continue;
            }
            buffer.append(current);
        }
        return buffer.toString();
    }
}

