/*
 * Decompiled with CFR 0.152.
 */
package de.weltraumschaf.freemarkerdown;

import de.weltraumschaf.commons.guava.Maps;
import de.weltraumschaf.commons.validate.Validate;
import de.weltraumschaf.freemarkerdown.BaseTemplate;
import de.weltraumschaf.freemarkerdown.Layout;
import de.weltraumschaf.freemarkerdown.TemplateModel;
import freemarker.template.Configuration;
import java.util.Map;
import net.jcip.annotations.NotThreadSafe;

@NotThreadSafe
final class LayoutImpl
extends BaseTemplate
implements Layout {
    private final Map<String, TemplateModel> fragments = Maps.newHashMap();

    LayoutImpl(String template, String encoding, Configuration freeMarkerConfig) {
        super(template, encoding, freeMarkerConfig);
    }

    @Override
    public void assignVariable(String name, Object value) {
        super.assignVariable(name, value);
        for (TemplateModel subTemplate : this.fragments.values()) {
            subTemplate.assignVariable(name, value);
        }
    }

    @Override
    public void assignTemplateModel(String name, TemplateModel template) {
        this.fragments.put(Validate.notEmpty((String)name, (String)"name"), (TemplateModel)Validate.notNull((Object)template, (String)"template"));
        for (Map.Entry<String, Object> variable : this.getTemplateVariables().entrySet()) {
            template.assignVariable(variable.getKey(), variable.getValue());
        }
    }

    @Override
    public String render() {
        for (Map.Entry<String, TemplateModel> fragment : this.fragments.entrySet()) {
            this.assignVariable(fragment.getKey(), fragment.getValue().render());
        }
        return super.render();
    }
}

