/*
 * Decompiled with CFR 0.152.
 */
package de.weltraumschaf.freemarkerdown;

import de.weltraumschaf.commons.guava.Lists;
import de.weltraumschaf.commons.validate.Validate;
import de.weltraumschaf.freemarkerdown.Defaults;
import de.weltraumschaf.freemarkerdown.PreProcessor;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import net.jcip.annotations.NotThreadSafe;

@NotThreadSafe
final class KeyValueProcessor
implements PreProcessor {
    private static final String TARGET = "fdm-keyvalue";
    private static final String SPLIT_TOKEN = ":";
    private static final String COMMENT_TOKEN = "//";
    private final Map<String, String> result;
    private final Collection<String> warnings = Lists.newArrayList();

    KeyValueProcessor(Map<String, String> result) {
        this.result = (Map)Validate.notNull(result, (String)"result");
    }

    @Override
    public boolean hasWarnings() {
        return !this.warnings.isEmpty();
    }

    @Override
    public Collection<String> getWarnings() {
        return Collections.unmodifiableCollection(this.warnings);
    }

    @Override
    public String getTarget() {
        return TARGET;
    }

    @Override
    public String process(String input) {
        Validate.notNull((Object)input, (String)"input");
        this.warnings.clear();
        for (String line : input.split(Defaults.DEFAULT_NEW_LINE.getValue())) {
            String value;
            if (line.trim().isEmpty() || line.trim().startsWith(COMMENT_TOKEN)) continue;
            if (!line.contains(SPLIT_TOKEN)) {
                this.warnings.add(String.format("Malformed line '%s'! Missing split token '%s'. Use format 'key %s value'.", line, SPLIT_TOKEN, SPLIT_TOKEN));
                continue;
            }
            String[] tokens = line.split(SPLIT_TOKEN);
            if (tokens.length == 0) {
                this.warnings.add(String.format("No key given: '%s'! Skipping line.", line));
                continue;
            }
            String name = tokens[0].trim();
            if (name.isEmpty()) {
                this.warnings.add(String.format("Empty key given: '%s'! Skipping line.", line));
                continue;
            }
            if (tokens.length == 1) {
                this.warnings.add(String.format("No value given: '%s'! Set vlaue empty.", name));
                value = "";
            } else {
                value = tokens[1].trim();
                if (value.isEmpty()) {
                    this.warnings.add(String.format("Empty value given: '%s'! Set vlaue empty.", name));
                }
            }
            this.result.put(name, value);
        }
        return "";
    }
}

