/*
 * Decompiled with CFR 0.152.
 */
package de.weltraumschaf.freemarkerdown;

import de.weltraumschaf.commons.validate.Validate;
import java.io.IOError;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import net.jcip.annotations.NotThreadSafe;

@NotThreadSafe
final class FreemarkerProperties {
    private static final String FILE = "/de/weltraumschaf/freemarkerdown/freemarker.properties";
    private final String propertyFileName;
    private final Properties properties = new Properties();

    FreemarkerProperties() {
        this(FILE);
    }

    FreemarkerProperties(String propertyFileName) {
        this.propertyFileName = Validate.notEmpty((String)propertyFileName, (String)"propertyFileName");
        this.load();
    }

    private void load() {
        InputStream in = null;
        try {
            in = this.getClass().getResourceAsStream(this.propertyFileName);
            this.properties.load(in);
            in.close();
        }
        catch (IOException | NullPointerException ex) {
            throw new IOError(ex);
        }
        finally {
            if (null != in) {
                try {
                    in.close();
                }
                catch (IOException ex) {
                    throw new IOError(ex);
                }
            }
        }
    }

    public String getVersion() {
        return this.properties.getProperty(PropertyNames.VERSION.toString(), PropertyNames.VERSION.getDefaultValue());
    }

    public String toString() {
        return this.getVersion();
    }

    private static enum PropertyNames {
        VERSION("version", "n/a");

        private final String name;
        private final String defaultValue;

        private PropertyNames(String name, String defaultValue) {
            this.name = name;
            this.defaultValue = defaultValue;
        }

        public String toString() {
            return this.name;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }
    }
}

