/*
 * Decompiled with CFR 0.152.
 */
package de.weltraumschaf.freemarkerdown;

import de.weltraumschaf.commons.guava.Lists;
import de.weltraumschaf.commons.guava.Sets;
import de.weltraumschaf.commons.validate.Validate;
import de.weltraumschaf.freemarkerdown.Defaults;
import de.weltraumschaf.freemarkerdown.Fragment;
import de.weltraumschaf.freemarkerdown.FragmentImpl;
import de.weltraumschaf.freemarkerdown.FreeMarker;
import de.weltraumschaf.freemarkerdown.Layout;
import de.weltraumschaf.freemarkerdown.LayoutImpl;
import de.weltraumschaf.freemarkerdown.Options;
import de.weltraumschaf.freemarkerdown.PreProcessor;
import de.weltraumschaf.freemarkerdown.TemplateModel;
import freemarker.template.Configuration;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.jcip.annotations.NotThreadSafe;
import org.pegdown.PegDownProcessor;

@NotThreadSafe
public final class FreeMarkerDown {
    public static final String DEFAULT_ENCODING = Defaults.ENCODING.getValue();
    private final List<PreProcessor> preProcessors = Lists.newArrayList();
    private final PegDownProcessor markdown;
    private final Configuration freeMarkerConfig;

    private FreeMarkerDown(Configuration freeMarkerConfig) {
        this(new PegDownProcessor(), freeMarkerConfig);
    }

    private FreeMarkerDown(PegDownProcessor markdown, Configuration freeMarkerConfig) {
        this.markdown = (PegDownProcessor)Validate.notNull((Object)markdown, (String)"markdown");
        this.freeMarkerConfig = (Configuration)Validate.notNull((Object)freeMarkerConfig, (String)"freeMarkerConfig");
    }

    public void register(PreProcessor processor) {
        Validate.notNull((Object)processor, (String)"processor");
        this.preProcessors.add(processor);
    }

    Collection<PreProcessor> getPreProcessors() {
        return Collections.unmodifiableList(this.preProcessors);
    }

    public String render(TemplateModel template, Options ... options) {
        Validate.notNull((Object)template, (String)"template");
        Set opt = options == null ? Collections.emptySet() : Sets.newHashSet((Object[])options);
        for (PreProcessor preProcessor : this.preProcessors) {
            template.apply(preProcessor);
        }
        String rendered = template.render();
        if (opt.contains((Object)Options.WITHOUT_MARKDOWN)) {
            return rendered;
        }
        return this.markdown.markdownToHtml(rendered);
    }

    public int hashCode() {
        return Objects.hashCode(this.preProcessors);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof FreeMarkerDown)) {
            return false;
        }
        FreeMarkerDown other = (FreeMarkerDown)obj;
        return Objects.equals(this.preProcessors, other.preProcessors);
    }

    public String toString() {
        return "FreeMarkerDown{preProcessors=" + this.preProcessors + '}';
    }

    public Fragment createFragemnt(String template) {
        return this.createFragemnt(template, DEFAULT_ENCODING);
    }

    public Fragment createFragemnt(String template, String encoding) {
        return new FragmentImpl(template, encoding, this.freeMarkerConfig);
    }

    public Fragment createFragemnt(Path template) throws IOException {
        return this.createFragemnt(template, DEFAULT_ENCODING);
    }

    public Fragment createFragemnt(Path template, String encoding) throws IOException {
        return this.createFragemnt(this.read(template, encoding), encoding);
    }

    public Layout createLayout(String template) {
        return this.createLayout(template, DEFAULT_ENCODING);
    }

    public Layout createLayout(String template, String encoding) {
        return new LayoutImpl(template, encoding, this.freeMarkerConfig);
    }

    public Layout createLayout(Path template) throws IOException {
        return this.createLayout(template, DEFAULT_ENCODING);
    }

    public Layout createLayout(Path template, String encoding) throws IOException {
        return this.createLayout(this.read(template, encoding), encoding);
    }

    private String read(Path template, String encoding) throws IOException {
        Validate.notNull((Object)template, (String)"template");
        Validate.notEmpty((String)encoding, (String)"encoding");
        return new String(Files.readAllBytes(template), encoding);
    }

    public static FreeMarkerDown create() {
        return FreeMarkerDown.create(new FreeMarker().createConfiguration());
    }

    public static FreeMarkerDown create(Configuration freeMarkerConfig) {
        return new FreeMarkerDown(freeMarkerConfig);
    }

    public static Configuration createConfiguration() {
        return new FreeMarker().createConfiguration();
    }
}

