/*
 * Decompiled with CFR 0.152.
 */
package de.weltraumschaf.freemarkerdown;

import de.weltraumschaf.commons.guava.Objects;
import de.weltraumschaf.commons.validate.Validate;
import de.weltraumschaf.freemarkerdown.FreeMarker;
import de.weltraumschaf.freemarkerdown.PreProcessor;
import de.weltraumschaf.freemarkerdown.PreProcessorApplier;
import de.weltraumschaf.freemarkerdown.PreProcessorApplierImpl;
import de.weltraumschaf.freemarkerdown.TemplateError;
import de.weltraumschaf.freemarkerdown.TemplateModel;
import de.weltraumschaf.freemarkerdown.Variables;
import freemarker.template.Configuration;
import freemarker.template.TemplateException;
import java.io.ByteArrayOutputStream;
import java.io.IOError;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Map;
import net.jcip.annotations.NotThreadSafe;

@NotThreadSafe
abstract class BaseTemplate
implements TemplateModel {
    private final Variables templateVariables = new Variables();
    private final String template;
    private final String encoding;
    private final Configuration freeMarkerConfig;
    private String preProcessedTemplate;
    private PreProcessorApplier preProcessorApplier = new PreProcessorApplierImpl();
    private FreeMarker factory = new FreeMarker();

    BaseTemplate(String template, String encoding, Configuration freeMarkerConfig) {
        this.preProcessedTemplate = this.template = (String)Validate.notNull((Object)template, (String)"template");
        this.encoding = Validate.notEmpty((String)encoding, (String)"encoding");
        this.freeMarkerConfig = (Configuration)Validate.notNull((Object)freeMarkerConfig, (String)"freeMarkerConfig");
    }

    final void setFactory(FreeMarker factory) {
        this.factory = (FreeMarker)Validate.notNull((Object)factory, (String)"factory");
    }

    final void setPreProcessorApplier(PreProcessorApplier preProcessorApplier) {
        this.preProcessorApplier = (PreProcessorApplier)Validate.notNull((Object)preProcessorApplier, (String)"preProcessorApplier");
    }

    final String getPreProcessedTemplate() {
        return this.preProcessedTemplate;
    }

    final Map<String, Object> getTemplateVariables() {
        return this.templateVariables.getVariables();
    }

    @Override
    public void assignVariable(String name, Object value) {
        this.templateVariables.assignVariable(name, value);
    }

    @Override
    public String render() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            this.factory.createTemplate(this.preProcessedTemplate, this.freeMarkerConfig).process(this.templateVariables.getVariables(), (Writer)new OutputStreamWriter((OutputStream)out, this.encoding));
            return out.toString(this.encoding);
        }
        catch (IOException ex) {
            throw new IOError(ex);
        }
        catch (TemplateException ex) {
            throw new TemplateError(ex.getMessage(), ex);
        }
    }

    @Override
    public final void apply(PreProcessor processor) {
        this.preProcessedTemplate = this.preProcessorApplier.apply(this.preProcessedTemplate, processor);
    }

    public final int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.templateVariables, this.encoding, this.template});
    }

    public final boolean equals(Object obj) {
        if (!(obj instanceof BaseTemplate)) {
            return false;
        }
        BaseTemplate other = (BaseTemplate)obj;
        return Objects.equal((Object)this.templateVariables, (Object)other.templateVariables) && Objects.equal((Object)this.encoding, (Object)other.encoding) && Objects.equal((Object)this.template, (Object)other.template);
    }

    public final String toString() {
        return "BaseTemplate{templateVariables=" + this.templateVariables + ", " + "template=" + this.template + ", " + "encoding=" + this.encoding + ", " + "preProcessedTemplate=" + this.preProcessedTemplate + '}';
    }
}

