/*
 * Decompiled with CFR 0.152.
 */
package de.weltraumschaf.commons.validate;

public final class Validate {
    private Validate() {
        throw new UnsupportedOperationException("Must not be caled via reflection!");
    }

    public static <T> T notNull(T reference, String name) {
        if (null == reference) {
            if (null == name) {
                throw new NullPointerException();
            }
            throw new NullPointerException(String.format("Parameter '%s' must not be null!", name));
        }
        return reference;
    }

    public static <T> T notNull(T reference) {
        return Validate.notNull(reference, null);
    }

    public static String notEmpty(String reference, String name) {
        Validate.notNull(reference, name);
        if (reference.isEmpty()) {
            if (null == name) {
                throw new IllegalArgumentException();
            }
            throw new IllegalArgumentException(String.format("Parameter '%s' must not be empty!", name));
        }
        return reference;
    }

    public static String notEmpty(String reference) {
        return Validate.notEmpty(reference, null);
    }

    public static int greaterThan(int reference, int lowerBound, String name) {
        if (reference <= lowerBound) {
            if (null == name) {
                throw new IllegalArgumentException();
            }
            throw new IllegalArgumentException(String.format("Parameter '%s' must be greater than %d (was %d)!", name, lowerBound, reference));
        }
        return reference;
    }

    public static int greaterThan(int reference, int lowerBound) {
        return Validate.greaterThan(reference, lowerBound, null);
    }

    public static int greaterThanOrEqual(int reference, int lowerBound, String name) {
        if (reference < lowerBound) {
            if (null == name) {
                throw new IllegalArgumentException();
            }
            throw new IllegalArgumentException(String.format("Parameter '%s' must be greater or equal than %d (was %d)!", name, lowerBound, reference));
        }
        return reference;
    }

    public static int greaterThanOrEqual(int reference, int lowerBound) {
        return Validate.greaterThanOrEqual(reference, lowerBound, null);
    }

    public static long greaterThan(long reference, long lowerBound, String name) {
        if (reference <= lowerBound) {
            if (null == name) {
                throw new IllegalArgumentException();
            }
            throw new IllegalArgumentException(String.format("Parameter '%s' must be greater than %d (was %d)!", name, lowerBound, reference));
        }
        return reference;
    }

    public static long greaterThan(long reference, long lowerBound) {
        return Validate.greaterThan(reference, lowerBound, null);
    }

    public static long greaterThanOrEqual(long reference, long lowerBound, String name) {
        if (reference < lowerBound) {
            if (null == name) {
                throw new IllegalArgumentException();
            }
            throw new IllegalArgumentException(String.format("Parameter '%s' must be greater than or equal %d (was %d)!", name, lowerBound, reference));
        }
        return reference;
    }

    public static long greaterThanOrEqual(long reference, long lowerBound) {
        return Validate.greaterThanOrEqual(reference, lowerBound, null);
    }

    public static void isTrue(boolean expression, String message) {
        Validate.notEmpty(message, "Parameter 'message' must not be null or empty!");
        if (!expression) {
            throw new IllegalArgumentException(message);
        }
    }
}

