/*
 * Decompiled with CFR 0.152.
 */
package de.weltraumschaf.commons.uri;

import de.weltraumschaf.commons.uri.CharacterIterator;
import de.weltraumschaf.commons.uri.UriComponent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

class UriTemplateParser {
    static final int[] EMPTY_INT_ARRAY = new int[0];
    private static final Set<Character> RESERVED_REGEX_CHARACTERS = UriTemplateParser.initReserved();
    private static final Pattern TEMPLATE_VALUE_PATTERN = Pattern.compile("[^/]+?");
    private static final String[] HEX_TO_UPPERCASE_REGEX = UriTemplateParser.initHexToUpperCaseRegex();
    private final String template;
    private final StringBuffer regex = new StringBuffer();
    private final StringBuffer normalizedTemplate = new StringBuffer();
    private final StringBuffer literalCharactersBuffer = new StringBuffer();
    private final Pattern pattern;
    private final List<String> names = new ArrayList<String>();
    private final List<Integer> groupCounts = new ArrayList<Integer>();
    private final Map<String, Pattern> nameToPattern = new HashMap<String, Pattern>();
    private int numOfExplicitRegexes;
    private int literalCharacters;

    private static Set<Character> initReserved() {
        char[] reserved = new char[]{'.', '^', '&', '!', '?', '-', ':', '<', '(', '[', '$', '=', ')', ']', ',', '>', '*', '+', '|'};
        HashSet<Character> s = new HashSet<Character>(reserved.length);
        for (char c : reserved) {
            s.add(Character.valueOf(c));
        }
        return s;
    }

    UriTemplateParser(String template) throws IllegalArgumentException {
        if (template == null || template.length() == 0) {
            throw new IllegalArgumentException();
        }
        this.template = template;
        this.parse(new CharacterIterator(template));
        try {
            this.pattern = Pattern.compile(this.regex.toString());
        }
        catch (PatternSyntaxException ex) {
            throw new IllegalArgumentException("Invalid syntax for the template expression '" + this.regex + "'", ex);
        }
    }

    final String getTemplate() {
        return this.template;
    }

    final Pattern getPattern() {
        return this.pattern;
    }

    final String getNormalizedTemplate() {
        return this.normalizedTemplate.toString();
    }

    final Map<String, Pattern> getNameToPattern() {
        return this.nameToPattern;
    }

    final List<String> getNames() {
        return this.names;
    }

    final List<Integer> getGroupCounts() {
        return this.groupCounts;
    }

    final int[] getGroupIndexes() {
        int i;
        if (this.names.isEmpty()) {
            return EMPTY_INT_ARRAY;
        }
        int[] indexes = new int[this.names.size() + 1];
        indexes[0] = 1;
        for (i = 1; i < indexes.length; ++i) {
            indexes[i] = indexes[i - 1] + this.groupCounts.get(i - 1);
        }
        for (i = 0; i < indexes.length; ++i) {
            if (indexes[i] == i + 1) continue;
            return indexes;
        }
        return EMPTY_INT_ARRAY;
    }

    final int getNumberOfExplicitRegexes() {
        return this.numOfExplicitRegexes;
    }

    final int getNumberOfLiteralCharacters() {
        return this.literalCharacters;
    }

    protected String encodeLiteralCharacters(String characters) {
        return characters;
    }

    private void parse(CharacterIterator ci) {
        try {
            while (ci.hasNext()) {
                char c = ci.next();
                if (c == '{') {
                    this.processLiteralCharacters();
                    this.parseName(ci);
                    continue;
                }
                this.literalCharactersBuffer.append(c);
            }
            this.processLiteralCharacters();
        }
        catch (NoSuchElementException ex) {
            throw new IllegalArgumentException(String.format("Invalid syntax in the template \"%s\". Check if a path parameter is terminated with a \"}\".", this.template), ex);
        }
    }

    private void processLiteralCharacters() {
        if (this.literalCharactersBuffer.length() > 0) {
            this.literalCharacters += this.literalCharactersBuffer.length();
            String s = this.encodeLiteralCharacters(this.literalCharactersBuffer.toString());
            this.normalizedTemplate.append(s);
            for (int i = 0; i < s.length(); ++i) {
                char c = s.charAt(i);
                if (RESERVED_REGEX_CHARACTERS.contains(Character.valueOf(c))) {
                    this.regex.append("\\");
                    this.regex.append(c);
                    continue;
                }
                if (c == '%') {
                    char c1 = s.charAt(i + 1);
                    char c2 = s.charAt(i + 2);
                    if (!UriComponent.isHexCharacter(c1) || !UriComponent.isHexCharacter(c2)) continue;
                    this.regex.append("%").append(HEX_TO_UPPERCASE_REGEX[c1]).append(HEX_TO_UPPERCASE_REGEX[c2]);
                    i += 2;
                    continue;
                }
                this.regex.append(c);
            }
            this.literalCharactersBuffer.setLength(0);
        }
    }

    private static String[] initHexToUpperCaseRegex() {
        char c;
        String[] table = new String[128];
        for (int i = 0; i < table.length; ++i) {
            table[i] = String.valueOf((char)i);
        }
        for (c = 'a'; c <= 'f'; c = (char)(c + '\u0001')) {
            table[c] = new StringBuffer().append("[").append(c).append((char)(c - 97 + 65)).append("]").toString();
        }
        for (c = 'A'; c <= 'F'; c = (char)(c + '\u0001')) {
            table[c] = new StringBuffer().append("[").append((char)(c - 65 + 97)).append(c).append("]").toString();
        }
        return table;
    }

    private void parseName(CharacterIterator ci) {
        char c = this.consumeWhiteSpace(ci);
        StringBuilder nameBuffer = new StringBuilder();
        if (!Character.isLetterOrDigit(c) && c != '_') {
            throw new IllegalArgumentException(String.format("Illegal character \"%s\" at position %s is not allowed as a start of a name in a path template \"%s\".", Character.valueOf(c), ci.pos(), this.template));
        }
        nameBuffer.append(c);
        String nameRegexString = "";
        while (Character.isLetterOrDigit(c = ci.next()) || c == '_' || c == '-' || c == '.') {
            nameBuffer.append(c);
        }
        if (c == ':') {
            nameRegexString = this.parseRegex(ci);
        } else if (c != '}') {
            if (c == ' ') {
                c = this.consumeWhiteSpace(ci);
                if (c == ':') {
                    nameRegexString = this.parseRegex(ci);
                } else if (c != '}') {
                    throw new IllegalArgumentException(String.format("Illegal character \"%s\" at position %s is not allowed after a name in a path template \"%s\".", Character.valueOf(c), ci.pos(), this.template));
                }
            } else {
                throw new IllegalArgumentException(String.format("Illegal character \"%s\" at position %s is not allowed as a part of a name in a path template \"%s\".", Character.valueOf(c), ci.pos(), this.template));
            }
        }
        String name = nameBuffer.toString();
        this.names.add(name);
        try {
            Pattern namePattern;
            if (nameRegexString.length() > 0) {
                ++this.numOfExplicitRegexes;
            }
            Pattern pattern = namePattern = nameRegexString.length() == 0 ? TEMPLATE_VALUE_PATTERN : Pattern.compile(nameRegexString);
            if (this.nameToPattern.containsKey(name)) {
                if (!this.nameToPattern.get(name).equals(namePattern)) {
                    throw new IllegalArgumentException(String.format("The name \"%s\" is declared more than once with different regular expressions in a path template \"%s\".", name, this.template));
                }
            } else {
                this.nameToPattern.put(name, namePattern);
            }
            Matcher m = namePattern.matcher("");
            int g = m.groupCount();
            this.groupCounts.add(g + 1);
            this.regex.append('(').append(namePattern).append(')');
            this.normalizedTemplate.append('{').append(name).append('}');
        }
        catch (PatternSyntaxException ex) {
            throw new IllegalArgumentException(String.format("Invalid syntax in the template \"%s\". Check if a path parameter is terminated with a \"}\".", nameRegexString, name, this.template), ex);
        }
    }

    private String parseRegex(CharacterIterator ci) {
        StringBuilder regexBuffer = new StringBuilder();
        int braceCount = 1;
        while (true) {
            char c;
            if ((c = ci.next()) == '{') {
                ++braceCount;
            } else if (c == '}' && --braceCount == 0) break;
            regexBuffer.append(c);
        }
        return regexBuffer.toString().trim();
    }

    private char consumeWhiteSpace(CharacterIterator ci) {
        char c;
        while (Character.isWhitespace(c = ci.next())) {
        }
        return c;
    }
}

