/*
 * Decompiled with CFR 0.152.
 */
package de.weltraumschaf.commons.uri;

import de.weltraumschaf.commons.uri.MultivaluedHashMap;
import de.weltraumschaf.commons.uri.MultivaluedMap;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.List;

final class MultivaluedStringMap
extends MultivaluedHashMap<String, String> {
    static final long serialVersionUID = -6052320403766368902L;

    MultivaluedStringMap(MultivaluedMap<? extends String, ? extends String> map) {
        super(map);
    }

    MultivaluedStringMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    MultivaluedStringMap(int initialCapacity) {
        super(initialCapacity);
    }

    MultivaluedStringMap() {
    }

    @Override
    protected void addFirstNull(List<String> values) {
        values.add("");
    }

    @Override
    protected void addNull(List<String> values) {
        values.add(0, "");
    }

    <A> A getFirst(String key, Class<A> type) {
        String value = (String)this.getFirst(key);
        if (value == null) {
            return null;
        }
        Constructor<A> c = null;
        try {
            c = type.getConstructor(String.class);
        }
        catch (NoSuchMethodException | SecurityException ex) {
            throw new IllegalArgumentException(type.getName() + " has no String constructor", ex);
        }
        A retVal = null;
        try {
            retVal = c.newInstance(value);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException ex) {
            // empty catch block
        }
        return retVal;
    }

    <A> A getFirst(String key, A defaultValue) {
        String value = (String)this.getFirst(key);
        if (value == null) {
            return defaultValue;
        }
        Class<?> type = defaultValue.getClass();
        Constructor<?> c = null;
        try {
            c = type.getConstructor(String.class);
        }
        catch (NoSuchMethodException | SecurityException ex) {
            throw new IllegalArgumentException(type.getName() + " has no String constructor", ex);
        }
        Object retVal = defaultValue;
        try {
            retVal = c.newInstance(value);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException ex) {
            // empty catch block
        }
        return retVal;
    }
}

