/*
 * Decompiled with CFR 0.152.
 */
package de.weltraumschaf.commons.uri;

import de.weltraumschaf.commons.uri.BaseUriBuilder;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAnyAttribute;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.namespace.QName;

abstract class Link {
    public static final String TITLE = "title";
    public static final String REL = "rel";
    public static final String TYPE = "type";

    Link() {
    }

    public abstract URI getUri();

    public abstract BaseUriBuilder getUriBuilder();

    public abstract String getRel();

    public abstract List<String> getRels();

    public abstract String getTitle();

    public abstract String getType();

    public abstract Map<String, String> getParams();

    public abstract String toString();

    public static class JaxbLink {
        private URI uri;
        private Map<QName, Object> params;

        public JaxbLink() {
        }

        public JaxbLink(URI uri) {
            this.uri = uri;
        }

        public JaxbLink(URI uri, Map<QName, Object> params) {
            this.uri = uri;
            this.params = params;
        }

        @XmlAttribute(name="href")
        public URI getUri() {
            return this.uri;
        }

        @XmlAnyAttribute
        public Map<QName, Object> getParams() {
            if (this.params == null) {
                this.params = new HashMap<QName, Object>();
            }
            return this.params;
        }
    }

    public static interface Builder {
        public Builder link(Link var1);

        public Builder link(String var1);

        public Builder uri(URI var1);

        public Builder uri(String var1);

        public Builder baseUri(URI var1);

        public Builder baseUri(String var1);

        public Builder uriBuilder(BaseUriBuilder var1);

        public Builder rel(String var1);

        public Builder title(String var1);

        public Builder type(String var1);

        public Builder param(String var1, String var2);

        public Link build(Object ... var1);

        public Link buildRelativized(URI var1, Object ... var2);
    }
}

