/*
 * Decompiled with CFR 0.152.
 */
package de.weltraumschaf.commons.uri;

import java.util.NoSuchElementException;

final class CharacterIterator {
    private int pos;
    private String s;

    CharacterIterator(String s) {
        this.s = s;
        this.pos = -1;
    }

    boolean hasNext() {
        return this.pos < this.s.length() - 1;
    }

    char next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.s.charAt(++this.pos);
    }

    char peek() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.s.charAt(this.pos + 1);
    }

    int pos() {
        return this.pos;
    }

    String getInput() {
        return this.s;
    }

    void setPosition(int newPosition) {
        if (newPosition > this.s.length() - 1) {
            throw new IndexOutOfBoundsException("Given position " + newPosition + " is outside the input string range.");
        }
        this.pos = newPosition;
    }

    char current() {
        if (this.pos == -1) {
            throw new IllegalStateException("Iterator not used yet.");
        }
        return this.s.charAt(this.pos);
    }
}

