/*
 * Decompiled with CFR 0.152.
 */
package de.weltraumschaf.commons.uri;

import de.weltraumschaf.commons.uri.Link;
import de.weltraumschaf.commons.uri.UriBuilder;
import de.weltraumschaf.commons.uri.UriBuilderException;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.Map;

abstract class BaseUriBuilder {
    protected BaseUriBuilder() {
    }

    protected static BaseUriBuilder newInstance() {
        return new UriBuilder();
    }

    static BaseUriBuilder fromUri(URI uri) {
        return BaseUriBuilder.newInstance().uri(uri);
    }

    static BaseUriBuilder fromUri(String uriTemplate) {
        return BaseUriBuilder.newInstance().uri(uriTemplate);
    }

    static BaseUriBuilder fromLink(Link link) {
        if (link == null) {
            throw new IllegalArgumentException("The provider 'link' parameter value is 'null'.");
        }
        return BaseUriBuilder.fromUri(link.getUri());
    }

    static BaseUriBuilder fromPath(String path) throws IllegalArgumentException {
        return BaseUriBuilder.newInstance().path(path);
    }

    static BaseUriBuilder fromResource(Class<?> resource) {
        return BaseUriBuilder.newInstance().path(resource);
    }

    public abstract BaseUriBuilder clone();

    abstract BaseUriBuilder uri(URI var1);

    abstract BaseUriBuilder uri(String var1);

    abstract BaseUriBuilder scheme(String var1);

    abstract BaseUriBuilder schemeSpecificPart(String var1);

    abstract BaseUriBuilder userInfo(String var1);

    abstract BaseUriBuilder host(String var1);

    abstract BaseUriBuilder port(int var1);

    abstract BaseUriBuilder replacePath(String var1);

    abstract BaseUriBuilder path(String var1);

    abstract BaseUriBuilder path(Class var1);

    abstract BaseUriBuilder path(Method var1);

    abstract BaseUriBuilder segment(String ... var1);

    abstract BaseUriBuilder replaceMatrix(String var1);

    abstract BaseUriBuilder matrixParam(String var1, Object ... var2);

    abstract BaseUriBuilder replaceMatrixParam(String var1, Object ... var2);

    abstract BaseUriBuilder replaceQuery(String var1);

    abstract BaseUriBuilder queryParam(String var1, Object ... var2);

    abstract BaseUriBuilder replaceQueryParam(String var1, Object ... var2);

    abstract BaseUriBuilder fragment(String var1);

    abstract BaseUriBuilder resolveTemplate(String var1, Object var2);

    abstract BaseUriBuilder resolveTemplate(String var1, Object var2, boolean var3);

    abstract BaseUriBuilder resolveTemplateFromEncoded(String var1, Object var2);

    abstract BaseUriBuilder resolveTemplates(Map<String, Object> var1);

    abstract BaseUriBuilder resolveTemplates(Map<String, Object> var1, boolean var2) throws IllegalArgumentException;

    abstract BaseUriBuilder resolveTemplatesFromEncoded(Map<String, Object> var1);

    abstract URI buildFromMap(Map<String, ?> var1);

    abstract URI buildFromMap(Map<String, ?> var1, boolean var2) throws IllegalArgumentException, UriBuilderException;

    abstract URI buildFromEncodedMap(Map<String, ?> var1) throws IllegalArgumentException, UriBuilderException;

    abstract URI build(Object ... var1) throws IllegalArgumentException, UriBuilderException;

    abstract URI build(Object[] var1, boolean var2) throws IllegalArgumentException, UriBuilderException;

    abstract URI buildFromEncoded(Object ... var1) throws IllegalArgumentException, UriBuilderException;

    abstract String toTemplate();
}

