/*
 * Decompiled with CFR 0.152.
 */
package de.weltraumschaf.commons.testing.hamcrest;

import de.weltraumschaf.commons.application.ApplicationException;
import de.weltraumschaf.commons.system.ExitCode;
import de.weltraumschaf.commons.validate.Validate;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public final class ApplicationExceptionCodeMatcher<T extends ApplicationException>
extends TypeSafeMatcher<T> {
    private final int expectedExitCodeNumber;
    private ExitCode expectedExitCode;

    @Deprecated
    public ApplicationExceptionCodeMatcher(ExitCode expectedExitCode) {
        this(((ExitCode)Validate.notNull((Object)expectedExitCode, (String)"expectedExitCode")).getCode());
        this.expectedExitCode = expectedExitCode;
    }

    private ApplicationExceptionCodeMatcher(int expectedExitCode) {
        this.expectedExitCodeNumber = expectedExitCode;
    }

    int getExpectedExitCodeNumber() {
        return this.expectedExitCodeNumber;
    }

    ExitCode getExpectedExitCode() {
        return this.expectedExitCode;
    }

    public void describeTo(Description description) {
        description.appendText("exception with exit code ");
        if (null == this.expectedExitCode) {
            description.appendValue((Object)this.expectedExitCodeNumber);
        } else {
            description.appendValue((Object)this.expectedExitCode);
        }
    }

    protected boolean matchesSafely(T item) {
        return this.expectedExitCodeNumber == item.getExitCode().getCode();
    }

    protected void describeMismatchSafely(T item, Description mismatch) {
        mismatch.appendText("exit code ");
        mismatch.appendText(item.getExitCode().toString());
    }

    @Factory
    public static <T extends ApplicationException> Matcher<T> hasExitCode(ExitCode expectedExitCode) {
        return new ApplicationExceptionCodeMatcher<T>(expectedExitCode);
    }

    public static <T extends ApplicationException> Matcher<T> hasExitCode(int expectedExitCode) {
        return new ApplicationExceptionCodeMatcher<T>(expectedExitCode);
    }
}

